/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes.factory;

import java.io.InputStream;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.internal.event.EventUtils;

@NoExtend
public abstract class AbstractCursorStreamProviderFactory
extends AbstractComponent
implements CursorStreamProviderFactory {
    protected final ByteBufferManager bufferManager;
    protected final StreamingManager streamingManager;
    protected static final boolean trackCursorProviderClose = Boolean.getBoolean("mule.track.cursorProvider.close");

    protected AbstractCursorStreamProviderFactory(ByteBufferManager bufferManager, StreamingManager streamingManager) {
        this.bufferManager = bufferManager;
        this.streamingManager = streamingManager;
    }

    @Override
    public final Object of(EventContext eventContext, InputStream inputStream, ComponentLocation originatingLocation) {
        if (inputStream instanceof CursorStream) {
            return this.streamingManager.manage(((CursorStream)inputStream).getProvider(), eventContext);
        }
        CursorProvider<CursorStream> value = this.resolve(inputStream, eventContext, originatingLocation);
        if (value instanceof CursorStreamProvider) {
            value = this.streamingManager.manage((CursorStreamProvider)value, eventContext);
        }
        return value;
    }

    @Override
    public final Object of(EventContext eventContext, InputStream inputStream) {
        return this.of(eventContext, inputStream, (ComponentLocation)null);
    }

    @Override
    public final Object of(CoreEvent event, InputStream inputStream, ComponentLocation originatingLocation) {
        return this.of(EventUtils.getRoot(event.getContext()), inputStream, originatingLocation);
    }

    @Override
    public final Object of(CoreEvent event, InputStream inputStream) {
        return this.of(EventUtils.getRoot(event.getContext()), inputStream, (ComponentLocation)null);
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected abstract Object resolve(InputStream var1, EventContext var2, ComponentLocation var3);

    @Deprecated
    protected abstract Object resolve(InputStream var1, CoreEvent var2, ComponentLocation var3);
}

