/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.connection.CachedConnectionHandler;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;

final class CachedConnectionManagementStrategy<C>
extends ConnectionManagementStrategy<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedConnectionManagementStrategy.class);
    private LifecycleState deploymentLifecycleState;
    private final Lock connectionLock = new ReentrantLock();
    private LazyValue<ConnectionHandlerAdapter<C>> connectionHandler;

    CachedConnectionManagementStrategy(ConnectionProvider<C> connectionProvider, LifecycleState deploymentLifecycleState) {
        super(connectionProvider);
        this.deploymentLifecycleState = deploymentLifecycleState;
        this.lazyConnect();
    }

    @Override
    public ConnectionHandler<C> getConnectionHandler() throws ConnectionException {
        try {
            return this.connectionHandler.get();
        }
        catch (Throwable t) {
            t = Exceptions.unwrap((Throwable)t);
            if (t instanceof ConnectionException) {
                throw (ConnectionException)t;
            }
            throw new ConnectionException(t.getMessage(), t);
        }
    }

    @Override
    public void close() throws MuleException {
        this.connectionHandler.ifComputed(this::close);
    }

    private synchronized void lazyConnect() {
        this.connectionLock.lock();
        try {
            this.connectionHandler = new LazyValue<CheckedSupplier<ConnectionHandlerAdapter>>(this::createConnection);
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    private ConnectionHandlerAdapter<C> createConnection() throws ConnectionException {
        LifecycleUtils.assertNotStopping(this.deploymentLifecycleState, "Mule is shutting down... Cannot establish new connections");
        return new CachedConnectionHandler(this.connectionProvider.connect(), this::invalidate, this.connectionProvider);
    }

    private void close(ConnectionHandlerAdapter<C> connectionHandler) {
        try {
            connectionHandler.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing cached connection", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(ConnectionHandlerAdapter<C> connection) {
        try {
            this.close(connection);
        }
        finally {
            this.connectionLock.lock();
            try {
                this.lazyConnect();
            }
            finally {
                this.connectionLock.unlock();
            }
        }
    }
}

