/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectivityTester;
import org.mule.runtime.core.internal.connection.ConnectivityTesterFactory;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectivityTesterFactory
implements ConnectivityTesterFactory {
    public static final String DO_TEST_CONNECTIVITY_PROPERTY_NAME = "doTestConnectivity";
    private static final String ASYNC_TEST_CONNECTIVITY_LOCK_TIMEOUT_PROPERTY = "mule.async.test.connectivity.lock.timeout";
    private static final Integer DEFAULT_ASYNC_TEST_CONNECTIVITY_TIMEOUT = 30000;
    private static final Integer DEFAULT_ASYNC_TEST_CONNECTIVITY_LOCK_TIMEOUT = 10000;
    private static final int ASYNC_TEST_CONNECTIVITY_TIMEOUT = Integer.getInteger("mule.async.test.connectivity.timeout", DEFAULT_ASYNC_TEST_CONNECTIVITY_TIMEOUT);
    private static final int ASYNC_TEST_CONNECTIVITY_LOCK_TIMEOUT = Integer.getInteger("mule.async.test.connectivity.lock.timeout", DEFAULT_ASYNC_TEST_CONNECTIVITY_LOCK_TIMEOUT);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnectivityTesterFactory.class);
    private ConnectionManagerAdapter connectionManager;
    private LockFactory lockFactory;
    private SchedulerService schedulerService;
    private final LazyValue<Boolean> doTestConnectivity = new LazyValue<Supplier<Boolean>>(this::getDoTestConnectivityProperty);

    @Inject
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Inject
    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    @Inject
    public void setConnectionManager(ConnectionManagerAdapter connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectivityTester create(final String name) {
        final Lock testConnectivityLock = this.lockFactory.createLock(this.getClass().getName() + "-testConnectivity-" + name);
        return new ConnectivityTester(){

            @Override
            public void testConnectivity(ConnectionProvider provider, final ConfigurationInstance configurationInstance) throws MuleException {
                if (provider instanceof NoConnectivityTest || !DefaultConnectivityTesterFactory.this.doTestConnectivity.get().booleanValue()) {
                    return;
                }
                Scheduler retryScheduler = DefaultConnectivityTesterFactory.this.schedulerService.ioScheduler();
                RetryPolicyTemplate retryTemplate = DefaultConnectivityTesterFactory.this.connectionManager.getRetryTemplateFor(provider);
                final ReconnectionConfig reconnectionConfig = DefaultConnectivityTesterFactory.this.connectionManager.getReconnectionConfigFor(provider);
                final Latch latch = new Latch();
                RetryCallback retryCallback = new RetryCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doWork(RetryContext context) throws Exception {
                        block9: {
                            try {
                                if (testConnectivityLock == null) break block9;
                                boolean lockAcquired = testConnectivityLock.tryLock(ASYNC_TEST_CONNECTIVITY_LOCK_TIMEOUT, TimeUnit.MILLISECONDS);
                                if (lockAcquired) {
                                    LOGGER.debug("Doing testConnectivity() for config '{}'", (Object)name);
                                    try {
                                        ConnectionValidationResult result = DefaultConnectivityTesterFactory.this.connectionManager.testConnectivity(configurationInstance);
                                        if (result.isValid()) {
                                            context.setOk();
                                        } else {
                                            DefaultConnectivityTesterFactory.this.handleTestConnectivityFailure(name, reconnectionConfig, context, result);
                                        }
                                        break block9;
                                    }
                                    finally {
                                        testConnectivityLock.unlock();
                                    }
                                }
                                LOGGER.warn("There is a testConnectivity() already running for config '{}'", (Object)name);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    }

                    @Override
                    public String getWorkDescription() {
                        return String.format("Testing connectivity for config '%s'", name);
                    }

                    @Override
                    public Object getWorkOwner() {
                        return configurationInstance.getValue();
                    }
                };
                try {
                    retryTemplate.execute(retryCallback, retryScheduler);
                }
                catch (Exception e) {
                    throw new DefaultMuleException(I18nMessageFactory.createStaticMessage(String.format("Could not perform connectivity testing for config '%s'", name)), (Throwable)e);
                }
                finally {
                    if (retryTemplate.isAsync()) {
                        try {
                            latch.await(ASYNC_TEST_CONNECTIVITY_TIMEOUT, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            LOGGER.warn("InterruptedException while waiting for the test connectivity to finish", (Throwable)e);
                        }
                    }
                    if (retryScheduler != null) {
                        retryScheduler.stop();
                    }
                }
            }

            @Override
            public void withTestConnectivityLock(CheckedRunnable task) {
                testConnectivityLock.lock();
                try {
                    task.run();
                }
                finally {
                    testConnectivityLock.unlock();
                }
            }
        };
    }

    private void handleTestConnectivityFailure(String name, ReconnectionConfig reconnectionConfig, RetryContext context, ConnectionValidationResult result) throws ConnectionException {
        if (reconnectionConfig.isFailsDeployment()) {
            context.setFailed(result.getException());
            throw new ConnectionException(String.format("Connectivity test failed for config '%s'", name), (Throwable)result.getException());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Connectivity test failed for config '%s'. Application deployment will continue. Error was: %s", name, result.getMessage()), (Throwable)result.getException());
        }
    }

    private boolean getDoTestConnectivityProperty() {
        return System.getProperty(DO_TEST_CONNECTIVITY_PROPERTY_NAME) != null ? Boolean.valueOf(System.getProperty(DO_TEST_CONNECTIVITY_PROPERTY_NAME)) : true;
    }
}

