/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.mule.runtime.core.internal.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.transaction.TransactionAdapter;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.transaction.TransactionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeginAndResolveTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeginAndResolveTransactionInterceptor.class);
    private final ExecutionInterceptor<T> next;
    private final MuleTransactionConfig transactionConfig;
    private final String applicationName;
    private final NotificationDispatcher notificationDispatcher;
    private final boolean processOnException;
    private final boolean mustResolveAnyTransaction;
    private final boolean errorAtTimeout;

    public BeginAndResolveTransactionInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig, String applicationName, NotificationDispatcher notificationDispatcher, boolean processOnException, boolean mustResolveAnyTransaction, boolean errorAtTimeout) {
        this.next = next;
        this.transactionConfig = (MuleTransactionConfig)transactionConfig;
        this.applicationName = applicationName;
        this.notificationDispatcher = notificationDispatcher;
        this.processOnException = processOnException;
        this.mustResolveAnyTransaction = mustResolveAnyTransaction;
        this.errorAtTimeout = errorAtTimeout;
    }

    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        byte action = this.transactionConfig.getAction();
        int timeout = this.transactionConfig.getTimeout();
        boolean resolveStartedTransaction = false;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 1 || action == 2 && tx == null) {
            logger.debug("Beginning transaction");
            executionContext.markTransactionStart();
            tx = this.transactionConfig.getFactory().beginTransaction(this.applicationName, this.notificationDispatcher);
            tx.setTimeout(timeout);
            if (tx instanceof TransactionAdapter) {
                TransactionAdapter txAdapter = (TransactionAdapter)tx;
                txAdapter.setRollbackIfTimeout(this.errorAtTimeout);
            }
            resolveStartedTransaction = true;
            logger.debug("Transaction successfully started: {}", (Object)tx);
        }
        try {
            T result = this.next.execute(callback, executionContext);
            this.resolveTransactionIfRequired(resolveStartedTransaction);
            return result;
        }
        catch (MessagingException e) {
            if (this.processOnException) {
                this.rollbackTransactionIfRequired(resolveStartedTransaction || this.mustResolveAnyTransaction);
            }
            throw e;
        }
    }

    private void rollbackTransactionIfRequired(boolean mustResolveTransaction) {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
    }

    private void resolveTransactionIfRequired(boolean mustResolveTransaction) throws TransactionException {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().resolveTransaction();
        }
    }
}

