/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;

public class RetrySchedulerWrapper
implements Scheduler {
    private final Scheduler delegate;
    private final long retryTime;
    private final Runnable onRetry;

    public RetrySchedulerWrapper(Scheduler delegate, long retryTime) {
        this(delegate, retryTime, () -> {});
    }

    public RetrySchedulerWrapper(Scheduler delegate, long retryTime, Runnable onRetry) {
        this.delegate = delegate;
        this.retryTime = retryTime;
        this.onRetry = onRetry;
    }

    @Override
    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
        return this.delegate.scheduleWithCronExpression(command, cronExpression);
    }

    @Override
    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
        return this.delegate.scheduleWithCronExpression(command, cronExpression, timeZone);
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private <T> Future<T> runWithRetry(Supplier<Future<T>> operation) {
        while (!this.isShutdown() && !this.isTerminated()) {
            try {
                return operation.get();
            }
            catch (RejectedExecutionException ree) {
                this.onRetry.run();
                try {
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException();
                }
            }
        }
        throw new RejectedExecutionException(this.toString());
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.runWithRetry(() -> this.delegate.submit(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.runWithRetry(() -> this.delegate.submit(task, result));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.runWithRetry(() -> this.delegate.submit(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.runWithRetry(() -> {
            this.delegate.execute(command);
            return null;
        });
    }

    public String toString() {
        return "RetrySchedulerWrapper{" + this.delegate.toString() + "}";
    }
}

