/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class SecurityFilterMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable,
MuleContextAware {
    private MuleContext muleContext;
    private SecurityFilter filter;

    public SecurityFilterMessageProcessor(SecurityFilter filter) {
        this.filter = filter;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.muleContext.getInjector().inject(this.filter);
            LifecycleUtils.initialiseIfNeeded((Object)this.filter, this.muleContext);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public SecurityFilter getFilter() {
        return this.filter;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).map(event -> {
            try {
                return CoreEvent.builder(event).securityContext(this.filter.doFilter((CoreEvent)event)).build();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }

    public void setFilter(SecurityFilter filter) {
        this.filter = filter;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }
}

