/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestableElementDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithFunctionsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.function.ImmutableFunctionModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedChainModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedComponentModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionDeclarerUtils;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.ParameterModelComparator;
import org.mule.runtime.extension.internal.loader.DefaultProblemsHandler;
import org.mule.runtime.extension.internal.loader.enricher.BackPressureDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.BooleanParameterDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ClassLoaderDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ClusterSupportEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ConfigRefDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ConnectionProviderDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ContentParameterDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.DefaultStereotypeEnricher;
import org.mule.runtime.extension.internal.loader.enricher.DynamicConfigDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ErrorMappingsParameterDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ExecutionTypeDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ExtensionTypesDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ExtensionsErrorsDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ImplicitConfigEnricher;
import org.mule.runtime.extension.internal.loader.enricher.NamedObjectDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.OAuthDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ParameterDslDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ParameterLayoutOrderDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ReconnectionStrategyDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.RedeliveryPolicyDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.StreamingDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.TargetParameterDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.TransactionalDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.XmlDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.adapter.ConstructForwarderDecorator;
import org.mule.runtime.extension.internal.loader.validator.BackPressureModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ConfigurationModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ConnectionProviderNameModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ContentParameterModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ExclusiveParameterModelValidator;
import org.mule.runtime.extension.internal.loader.validator.FunctionModelValidator;
import org.mule.runtime.extension.internal.loader.validator.NameClashModelValidator;
import org.mule.runtime.extension.internal.loader.validator.NameModelValidator;
import org.mule.runtime.extension.internal.loader.validator.NoWrapperModelValidator;
import org.mule.runtime.extension.internal.loader.validator.OperationModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ParameterModelValidator;
import org.mule.runtime.extension.internal.loader.validator.SubtypesModelValidator;
import org.mule.runtime.extension.internal.loader.validator.TransactionalParametersValidator;
import org.mule.runtime.extension.internal.loader.validator.ValidatorModelValidator;
import org.mule.runtime.extension.privileged.loader.ProblemsHandler;

public final class ExtensionModelFactory {
    public static final String PROBLEMS_HANDLER = "PROBLEMS_HANDLER";
    private static final String AGGREGATORS_PACKAGE = "org.mule.extension.aggregator";
    private final List<DeclarationEnricher> declarationEnrichers = Collections.unmodifiableList(Arrays.asList(new ParameterDslDeclarationEnricher(), new BooleanParameterDeclarationEnricher(), new ClassLoaderDeclarationEnricher(), new ContentParameterDeclarationEnricher(), new ExecutionTypeDeclarationEnricher(), new ExtensionTypesDeclarationEnricher(), new XmlDeclarationEnricher(), new TargetParameterDeclarationEnricher(), new ExtensionsErrorsDeclarationEnricher(), new ErrorMappingsParameterDeclarationEnricher(), new ConnectionProviderDeclarationEnricher(), new DynamicConfigDeclarationEnricher(), new ReconnectionStrategyDeclarationEnricher(), new StreamingDeclarationEnricher(), new OAuthDeclarationEnricher(), new ConfigRefDeclarationEnricher(), new ImplicitConfigEnricher(), new DefaultStereotypeEnricher(), new NamedObjectDeclarationEnricher(), new TransactionalDeclarationEnricher(), new BackPressureDeclarationEnricher(), new ClusterSupportEnricher(), new RedeliveryPolicyDeclarationEnricher(), new ParameterLayoutOrderDeclarationEnricher()));
    private final List<ExtensionModelValidator> extensionModelValidators = Collections.unmodifiableList(Arrays.asList(new ConnectionProviderNameModelValidator(), new ContentParameterModelValidator(), new ExclusiveParameterModelValidator(), new NameClashModelValidator(), new OperationModelValidator(), new FunctionModelValidator(), new ParameterModelValidator(), new SubtypesModelValidator(), new TransactionalParametersValidator(), new ValidatorModelValidator(), new NameModelValidator(), new BackPressureModelValidator(), new NoWrapperModelValidator(), new ConnectionProviderNameModelValidator(), new ConfigurationModelValidator()));
    private final boolean testingMode = MuleSystemProperties.isTestingMode();

    public ExtensionModel create(ExtensionLoadingContext extensionLoadingContext) {
        this.enrichDeclaration(extensionLoadingContext);
        ExtensionModel extensionModel = new FactoryDelegate().toExtension((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        if (this.shouldValidate(extensionLoadingContext)) {
            ProblemsReporter problemsReporter = new ProblemsReporter(extensionModel);
            this.validate(extensionModel, problemsReporter, extensionLoadingContext);
            this.getProblemsHandler(extensionLoadingContext, extensionModel).handleProblems(problemsReporter);
        }
        return extensionModel;
    }

    private boolean shouldValidate(ExtensionLoadingContext extensionLoadingContext) {
        return this.testingMode || extensionLoadingContext.isForceExtensionValidation();
    }

    private void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter, ExtensionLoadingContext extensionLoadingContext) {
        LinkedList<ExtensionModelValidator> validators = new LinkedList<ExtensionModelValidator>(this.extensionModelValidators);
        validators.addAll(extensionLoadingContext.getCustomValidators());
        DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault(extensionModel, new SingleExtensionImportTypesStrategy());
        validators.forEach(v -> v.validate(extensionModel, dslSyntaxResolver, problemsReporter));
    }

    private void validateMuleVersion(ExtensionDeclaration extensionDeclaration) {
        String version = extensionDeclaration.getVersion();
        if (version == null || version.trim().length() == 0) {
            throw new IllegalModelDefinitionException(String.format("Extension '%s' did not specified a version", extensionDeclaration.getName()));
        }
        try {
            new MuleVersion(version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid version '%s' for extension '%s'", version, extensionDeclaration.getName()));
        }
    }

    private void enrichDeclaration(ExtensionLoadingContext extensionLoadingContext) {
        int enricherCount = this.declarationEnrichers.size() + extensionLoadingContext.getCustomDeclarationEnrichers().size();
        ArrayList<DeclarationEnricher> enrichers = new ArrayList<DeclarationEnricher>(enricherCount);
        enrichers.addAll(extensionLoadingContext.getCustomDeclarationEnrichers());
        enrichers.addAll(this.declarationEnrichers);
        enrichers.sort(Comparator.comparing(DeclarationEnricher::getExecutionPhase));
        ArrayList<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> walkDelegates = new ArrayList<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate>(enricherCount);
        DeclarationEnricherPhase currentPhase = DeclarationEnricherPhase.values()[0];
        for (DeclarationEnricher enricher : enrichers) {
            DeclarationEnricherPhase enricherPhase = enricher.getExecutionPhase();
            if (currentPhase != enricherPhase) {
                this.processEnricherWalkDelegates(extensionLoadingContext, walkDelegates);
                walkDelegates.clear();
                currentPhase = enricherPhase;
            }
            if (enricher instanceof WalkingDeclarationEnricher) {
                ((WalkingDeclarationEnricher)enricher).getWalkDelegate(extensionLoadingContext).ifPresent(walkDelegates::add);
                continue;
            }
            if (this.isAggregatorEnricher(enricher)) {
                this.applyEnricherWithProxyDeclaration(extensionLoadingContext, enricher);
                continue;
            }
            enricher.enrich(extensionLoadingContext);
        }
        this.processEnricherWalkDelegates(extensionLoadingContext, walkDelegates);
    }

    private void applyEnricherWithProxyDeclaration(ExtensionLoadingContext extensionLoadingContext, DeclarationEnricher enricher) {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        List<ConstructDeclaration> oldConstructs = this.addRoutersAsProxyConstructs(extensionDeclaration);
        enricher.enrich(extensionLoadingContext);
        extensionDeclaration.setConstructs(oldConstructs);
    }

    private boolean isAggregatorEnricher(DeclarationEnricher enricher) {
        return enricher.getClass().getPackage().getName().startsWith(AGGREGATORS_PACKAGE);
    }

    private List<ConstructDeclaration> addRoutersAsProxyConstructs(ExtensionDeclaration extensionDeclaration) {
        List<ConstructDeclaration> oldConstructs = extensionDeclaration.getConstructs();
        ArrayList<ConstructDeclaration> newConstructs = new ArrayList<ConstructDeclaration>(oldConstructs);
        extensionDeclaration.getOperations().stream().filter(ExtensionDeclarerUtils::isRouter).map(ConstructForwarderDecorator::new).forEach(newConstructs::add);
        extensionDeclaration.setConstructs(newConstructs);
        return oldConstructs;
    }

    private void processEnricherWalkDelegates(ExtensionLoadingContext extensionLoadingContext, final List<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> walkDelegates) {
        if (!walkDelegates.isEmpty()) {
            new DeclarationWalker(){

                @Override
                protected void onConfiguration(ConfigurationDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onConfiguration(declaration));
                }

                @Override
                protected void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onOperation(owner, declaration));
                }

                @Override
                protected void onFunction(WithFunctionsDeclaration owner, FunctionDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onFunction(owner, declaration));
                }

                @Override
                protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onConstruct(owner, declaration));
                }

                @Override
                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onConnectionProvider(owner, declaration));
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onSource(owner, declaration));
                }

                @Override
                protected void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onParameterGroup(owner, declaration));
                }

                @Override
                protected void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                    walkDelegates.forEach(d -> d.onParameter(owner, parameterGroup, declaration));
                }
            }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
            walkDelegates.forEach(WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate::onWalkFinished);
        }
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private Set<ObjectType> toExtensionTypes(Set<ObjectType> types, Set<ImportedTypeModel> importedTypes) {
        Set importedTypesIds = importedTypes.stream().map(ImportedTypeModel::getImportedType).map(type -> ExtensionMetadataTypeUtils.getId(type).orElse(null)).filter(type -> type != null).collect(Collectors.toSet());
        return types.stream().filter(t -> !importedTypesIds.contains(ExtensionMetadataTypeUtils.getId(t).orElse(""))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private ProblemsHandler getProblemsHandler(ExtensionLoadingContext extensionLoadingContext, ExtensionModel extensionModel) {
        return (ProblemsHandler)extensionLoadingContext.getParameter(PROBLEMS_HANDLER).orElseGet(() -> new DefaultProblemsHandler(extensionModel));
    }

    private class FactoryDelegate {
        private final Cache<ParameterizedDeclaration, ParameterizedModel> modelCache = CacheBuilder.newBuilder().build();

        private FactoryDelegate() {
        }

        private ExtensionModel toExtension(ExtensionDeclaration extensionDeclaration) {
            ExtensionModelFactory.this.validateMuleVersion(extensionDeclaration);
            ImmutableExtensionModel extensionModel = new ImmutableExtensionModel(extensionDeclaration.getName(), extensionDeclaration.getDescription(), extensionDeclaration.getVersion(), extensionDeclaration.getVendor(), extensionDeclaration.getCategory(), this.sortConfigurations(this.toConfigurations(extensionDeclaration.getConfigurations())), this.toOperations(extensionDeclaration.getOperations()), this.toConnectionProviders(extensionDeclaration.getConnectionProviders()), this.toMessageSources(extensionDeclaration.getMessageSources()), this.toFunctions(extensionDeclaration.getFunctions()), this.toConstructs(extensionDeclaration.getConstructs()), extensionDeclaration.getDisplayModel(), extensionDeclaration.getXmlDslModel(), extensionDeclaration.getSubTypes(), ExtensionModelFactory.this.toExtensionTypes(extensionDeclaration.getTypes(), extensionDeclaration.getImportedTypes()), extensionDeclaration.getResources(), extensionDeclaration.getImportedTypes(), extensionDeclaration.getErrorModels(), extensionDeclaration.getExternalLibraryModels(), extensionDeclaration.getPrivilegedPackages(), extensionDeclaration.getPrivilegedArtifacts(), extensionDeclaration.getModelProperties(), extensionDeclaration.getNotificationModels(), extensionDeclaration.getDeprecation().orElse(null), extensionDeclaration.getArtifactCoordinates().orElse(null), extensionDeclaration.getMinMuleVersion().orElse(null), this.resolveSupportedJavaVersions(extensionDeclaration));
            return extensionModel;
        }

        private Set<String> resolveSupportedJavaVersions(ExtensionDeclaration declaration) {
            Set<String> versions = declaration.getSupportedJavaVersions();
            return versions != null && !versions.isEmpty() ? versions : ExtensionConstants.DEFAULT_SUPPORTED_JAVA_VERSIONS;
        }

        private List<ConfigurationModel> sortConfigurations(List<ConfigurationModel> configurationModels) {
            if (configurationModels.isEmpty()) {
                return configurationModels;
            }
            return NameUtils.alphaSortDescribedList(configurationModels);
        }

        private List<ConfigurationModel> toConfigurations(List<ConfigurationDeclaration> declarations) {
            return declarations.stream().map(this::toConfiguration).collect(Collectors.toList());
        }

        private <T extends ParameterizedModel> T fromCache(ParameterizedDeclaration declaration, Supplier<ParameterizedModel> supplier) {
            try {
                return (T)((ParameterizedModel)this.modelCache.get((Object)declaration, supplier::get));
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(e);
            }
        }

        private ConfigurationModel toConfiguration(ConfigurationDeclaration declaration) {
            return (ConfigurationModel)this.fromCache(declaration, () -> new ImmutableConfigurationModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toOperations(declaration.getOperations()), this.toConnectionProviders(declaration.getConnectionProviders()), this.toMessageSources(declaration.getMessageSources()), declaration.getExternalLibraryModels(), declaration.getDisplayModel(), this.getConfigStereotype(declaration.getStereotype()), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getMinMuleVersion().orElse(null)));
        }

        private StereotypeModel getConfigStereotype(StereotypeModel stereotypeModel) {
            if (stereotypeModel != null) {
                return stereotypeModel;
            }
            return MuleStereotypes.CONFIG;
        }

        private List<ConstructModel> toConstructs(List<ConstructDeclaration> constructs) {
            return constructs.stream().map(this::toConstruct).collect(Collectors.toList());
        }

        private ConstructModel toConstruct(ConstructDeclaration declaration) {
            return (ConstructModel)this.fromCache(declaration, () -> new ImmutableConstructModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toNestedComponentModels(declaration.getNestedComponents()), declaration.allowsTopLevelDefinition(), declaration.getDisplayModel(), declaration.getErrorModels(), this.getProcessorStereotype(declaration.getStereotype()), declaration.getVisibility(), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null)));
        }

        private List<SourceModel> toMessageSources(List<SourceDeclaration> declarations) {
            return Collections.unmodifiableList(NameUtils.alphaSortDescribedList(declarations.stream().map(this::toMessageSource).collect(Collectors.toList())));
        }

        private SourceModel toMessageSource(SourceDeclaration declaration) {
            return (SourceModel)this.fromCache(declaration, () -> new ImmutableSourceModel(declaration.getName(), declaration.getDescription(), declaration.hasResponse(), declaration.isRunsOnPrimaryNodeOnly(), this.toParameterGroups(declaration.getParameterGroups()), this.toNestedComponentModels(declaration.getNestedComponents()), this.toOutputModel(declaration.getOutput()), this.toOutputModel(declaration.getOutputAttributes()), this.toSourceCallback(declaration.getSuccessCallback()), this.toSourceCallback(declaration.getErrorCallback()), this.toSourceCallback(declaration.getTerminateCallback()), declaration.isPolling(), declaration.isRequiresConnection(), declaration.isTransactional(), declaration.isSupportsStreaming(), declaration.getDisplayModel(), this.getSourceStereotypes(declaration), declaration.getErrorModels(), declaration.getVisibility(), declaration.getModelProperties(), declaration.getNotificationModels(), declaration.getDeprecation().orElse(null), declaration.getSampleDataProviderModel().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null)));
        }

        private StereotypeModel getSourceStereotypes(SourceDeclaration declaration) {
            if (declaration.getStereotype() != null) {
                return declaration.getStereotype();
            }
            return MuleStereotypes.SOURCE;
        }

        private Optional<SourceCallbackModel> toSourceCallback(Optional<SourceCallbackDeclaration> callbackDeclaration) {
            return callbackDeclaration.map(callback -> new ImmutableSourceCallbackModel(callback.getName(), callback.getDescription(), this.toParameterGroups(callback.getParameterGroups()), callback.getDisplayModel(), callback.getModelProperties()));
        }

        private Set<StereotypeModel> getProcessorStereotypes(Set<StereotypeModel> stereotypeModels) {
            if (!stereotypeModels.isEmpty()) {
                return stereotypeModels;
            }
            return ImmutableSet.of((Object)MuleStereotypes.PROCESSOR);
        }

        private StereotypeModel getProcessorStereotype(StereotypeModel stereotypeModel) {
            if (stereotypeModel != null) {
                return stereotypeModel;
            }
            return MuleStereotypes.PROCESSOR;
        }

        private List<OperationModel> toOperations(List<OperationDeclaration> declarations) {
            return Collections.unmodifiableList(NameUtils.alphaSortDescribedList(declarations.stream().map(this::toOperation).collect(Collectors.toList())));
        }

        private OperationModel toOperation(OperationDeclaration declaration) {
            return (OperationModel)this.fromCache(declaration, () -> {
                ImmutableOperationModel operation = new ImmutableOperationModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toNestedComponentModels(declaration.getNestedComponents()), this.toOutputModel(declaration.getOutput()), this.toOutputModel(declaration.getOutputAttributes()), declaration.isBlocking(), declaration.getExecutionType(), declaration.isRequiresConnection(), declaration.isTransactional(), declaration.isSupportsStreaming(), declaration.getDisplayModel(), declaration.getErrorModels(), this.getProcessorStereotype(declaration.getStereotype()), declaration.getVisibility(), declaration.getModelProperties(), declaration.getNotificationModels(), declaration.getDeprecation().orElse(null), declaration.getSampleDataProviderModel().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null));
                return operation;
            });
        }

        private List<NestableElementModel> toNestedComponentModels(List<NestableElementDeclaration> nestedComponents) {
            return nestedComponents.stream().map(this::toNestedComponent).collect(Collectors.toList());
        }

        private NestableElementModel toNestedComponent(NestableElementDeclaration declaration) {
            if (declaration instanceof NestedRouteDeclaration) {
                return new ImmutableNestedRouteModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), declaration.getDisplayModel(), declaration.getMinOccurs(), declaration.getMaxOccurs(), this.toNestedComponentModels(declaration.getNestedComponents()), declaration.getStereotype(), declaration.getVisibility(), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null));
            }
            if (declaration instanceof NestedChainDeclaration) {
                return new ImmutableNestedChainModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), declaration.isRequired(), this.getProcessorStereotypes(((NestedChainDeclaration)declaration).getAllowedStereotypes()), this.toNestedComponentModels(declaration.getNestedComponents()), declaration.getDisplayModel(), declaration.getErrorModels(), declaration.getStereotype(), declaration.getVisibility(), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null), ((NestedChainDeclaration)declaration).getOccurrence());
            }
            return new ImmutableNestedComponentModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), declaration.getMinOccurs(), declaration.getMaxOccurs(), this.getProcessorStereotypes(((NestedComponentDeclaration)declaration).getAllowedStereotypes()), this.toNestedComponentModels(declaration.getNestedComponents()), declaration.getDisplayModel(), declaration.getErrorModels(), declaration.getStereotype(), declaration.getVisibility(), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null));
        }

        private List<ConnectionProviderModel> toConnectionProviders(List<ConnectionProviderDeclaration> declarations) {
            return Collections.unmodifiableList(NameUtils.alphaSortDescribedList(declarations.stream().map(this::toConnectionProvider).collect(Collectors.toList())));
        }

        private OutputModel toOutputModel(OutputDeclaration declaration) {
            return declaration != null ? new ImmutableOutputModel(declaration.getDescription(), declaration.getType(), declaration.hasDynamicType(), declaration.getModelProperties()) : new ImmutableOutputModel("", BaseTypeBuilder.create(MetadataFormat.JAVA).voidType().build(), false, Collections.emptySet());
        }

        private ConnectionProviderModel toConnectionProvider(ConnectionProviderDeclaration declaration) {
            return (ConnectionProviderModel)this.fromCache(declaration, () -> new ImmutableConnectionProviderModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), declaration.getConnectionManagementType(), declaration.isSupportsConnectivityTesting(), declaration.isSupportsXa(), declaration.getExternalLibraryModels(), declaration.getDisplayModel(), this.getConnectionStereotype(declaration.getStereotype()), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getSemanticTerms(), declaration.getMinMuleVersion().orElse(null)));
        }

        private StereotypeModel getConnectionStereotype(StereotypeModel stereotypeModel) {
            if (stereotypeModel != null) {
                return stereotypeModel;
            }
            return MuleStereotypes.CONNECTION;
        }

        private List<ParameterGroupModel> toParameterGroups(List<ParameterGroupDeclaration> declarations) {
            if (declarations.isEmpty()) {
                return ImmutableList.of();
            }
            declarations = new ArrayList<ParameterGroupDeclaration>(declarations);
            declarations.sort((left, right) -> {
                if ("General".equals(left.getName())) {
                    return -1;
                }
                if ("General".equals(right.getName())) {
                    return 1;
                }
                return 0;
            });
            return Collections.unmodifiableList(declarations.stream().map(this::toParameterGroup).collect(Collectors.toList()));
        }

        private ParameterGroupModel toParameterGroup(ParameterGroupDeclaration declaration) {
            return new ImmutableParameterGroupModel(declaration.getName(), declaration.getDescription(), this.toParameters(declaration.getParameters()), this.toExclusiveParametersModels(declaration), declaration.isShowInDsl(), declaration.getDisplayModel(), declaration.getLayoutModel(), declaration.getModelProperties());
        }

        private List<ExclusiveParametersModel> toExclusiveParametersModels(ParameterGroupDeclaration groupDeclaration) {
            return Collections.unmodifiableList(groupDeclaration.getExclusiveParameters().stream().map(exclusive -> new ImmutableExclusiveParametersModel(exclusive.getParameterNames(), exclusive.isRequiresOne())).collect(Collectors.toList()));
        }

        private List<ParameterModel> toParameters(List<ParameterDeclaration> declarations) {
            if (declarations.isEmpty()) {
                return ImmutableList.of();
            }
            return Collections.unmodifiableList(declarations.stream().map(this::toParameter).sorted(new ParameterModelComparator(false)).collect(Collectors.toList()));
        }

        private ParameterModel toParameter(ParameterDeclaration parameter) {
            Object defaultValue = parameter.getDefaultValue();
            if (defaultValue instanceof String) {
                if (parameter.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED && ExtensionModelFactory.this.isExpression((String)defaultValue)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is marked as not supporting expressions yet it contains one as a default value. Please fix this", parameter.getName()));
                }
                if (parameter.getExpressionSupport() == ExpressionSupport.REQUIRED && !ExtensionModelFactory.this.isExpression((String)defaultValue)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' requires expressions yet it contains a constant as a default value. Please fix this", parameter.getName()));
                }
            }
            return new ImmutableParameterModel(parameter.getName(), parameter.getDescription(), parameter.getType(), parameter.hasDynamicType(), parameter.isRequired(), parameter.isConfigOverride(), parameter.isComponentId(), parameter.getExpressionSupport(), parameter.getDefaultValue(), parameter.getRole(), parameter.getDslConfiguration(), parameter.getDisplayModel(), parameter.getLayoutModel(), parameter.getValueProviderModel(), parameter.getAllowedStereotypeModels(), parameter.getModelProperties(), parameter.getDeprecation().orElse(null), parameter.getSemanticTerms(), parameter.getFieldValueProviderModels(), parameter.getMinMuleVersion().orElse(null));
        }

        private List<FunctionModel> toFunctions(List<FunctionDeclaration> expressionFunctions) {
            return Collections.unmodifiableList(expressionFunctions.stream().map(declaration -> new ImmutableFunctionModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toOutputModel(declaration.getOutput()), declaration.getDisplayModel(), declaration.getModelProperties(), declaration.getDeprecation().orElse(null), declaration.getMinMuleVersion().orElse(null))).collect(Collectors.toList()));
        }
    }
}

