/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.mule.runtime.http.api.sse.server.SseClientConfig;
import org.mule.runtime.http.support.internal.server.SseResponseCustomizerWrapper;
import org.mule.sdk.api.http.domain.message.request.ClientConnection;
import org.mule.sdk.api.http.domain.message.request.HttpRequestContext;
import org.mule.sdk.api.http.sse.server.SseClientConfigurer;
import org.mule.sdk.api.http.sse.server.SseResponseCustomizer;

public class SseClientConfigImpl
implements SseClientConfigurer {
    private String clientId;
    private InetSocketAddress remoteAddress;
    private Consumer<SseResponseCustomizer> responseCustomizer;

    @Override
    public SseClientConfigurer withRequestContext(HttpRequestContext requestContext) {
        return this.withRemoteAddress(SseClientConfigImpl.nullSafeGetAddress(requestContext));
    }

    @Override
    public SseClientConfigurer withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public SseClientConfigurer withRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @Override
    public SseClientConfigurer customizeResponse(Consumer<SseResponseCustomizer> callback) {
        this.responseCustomizer = callback;
        return this;
    }

    public SseClientConfig build() {
        return SseClientConfig.builder().withClientId(this.clientId).withRemoteAddress(this.remoteAddress).customizeResponse((org.mule.runtime.http.api.sse.server.SseResponseCustomizer customizer) -> this.responseCustomizer.accept(new SseResponseCustomizerWrapper((org.mule.runtime.http.api.sse.server.SseResponseCustomizer)customizer))).build();
    }

    private static InetSocketAddress nullSafeGetAddress(HttpRequestContext requestContext) {
        if (requestContext == null) {
            return null;
        }
        ClientConnection clientConnection = requestContext.getClientConnection();
        if (clientConnection == null) {
            return null;
        }
        return clientConnection.getRemoteHostAddress();
    }
}

