/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.impl;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.metrics.api.MeterProvider;
import org.mule.runtime.metrics.api.meter.builder.MeterBuilder;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.exporter.api.MeterExporterFactory;
import org.mule.runtime.metrics.impl.meter.DefaultMeter;
import org.mule.runtime.metrics.impl.meter.repository.MeterRepository;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;

public class DefaultMeterProvider
implements MeterProvider,
Disposable {
    private final MeterExporterFactory meterExporterFactory;
    private final ObservabilitySignalConfiguration meterExporterConfiguration;
    private final MeterRepository meterRepository = new MeterRepository();
    private final LazyValue<MeterExporter> meterExporter = new LazyValue<Supplier<MeterExporter>>(this::resolveMeterExporter);

    @Inject
    public DefaultMeterProvider(MeterExporterFactory meterExporterFactory, @Named(value="_muleMeterExporterConfiguration") ObservabilitySignalConfiguration meterExporterConfiguration) {
        this.meterExporterFactory = meterExporterFactory;
        this.meterExporterConfiguration = meterExporterConfiguration;
    }

    private MeterExporter resolveMeterExporter() {
        return this.meterExporterFactory.getMeterExporter(this.meterExporterConfiguration);
    }

    @Override
    public MeterBuilder getMeterBuilder(String meterName) {
        return DefaultMeter.builder(meterName).withMeterExporter(this.meterExporter.get()).withMeterRepository(this.meterRepository);
    }

    public MeterRepository getMeterRepository() {
        return this.meterRepository;
    }

    @Override
    public void dispose() {
        this.meterExporter.get().dispose();
    }
}

