/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.config.internal.dsl.utils.DslConstants;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureTypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

public class PollingSourceDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static final String POLLING_SOURCE_LIMIT_MULE_VERSION = "4.4.0";

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(final ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){
            final ClassTypeLoader loader;
            final int schedulingStrategyParameterSequence;
            final ExtensionDeclarer extensionDeclarer;
            boolean thereArePollingSources;
            {
                this.loader = extensionLoadingContext.getTypeLoader();
                this.schedulingStrategyParameterSequence = InfrastructureTypeResolver.getInfrastructureType(new TypeWrapper(SchedulingStrategy.class, this.loader)).map(InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType::getSequence).orElse(0);
                this.extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
                this.thereArePollingSources = false;
            }

            @Override
            protected void onSource(SourceDeclaration source) {
                if (source.isPolling()) {
                    this.thereArePollingSources = true;
                    ParameterGroupDeclaration defaultGroupDeclaration = source.getParameterGroup("General");
                    defaultGroupDeclaration.addParameter(this.declareSchedulingStrategyParameter(this.loader));
                    if (MuleExtensionUtils.isPollingSourceLimitEnabled(extensionLoadingContext)) {
                        defaultGroupDeclaration.addParameter(this.declarePollingSourceLimitParameter());
                    }
                }
            }

            private ParameterDeclaration declarePollingSourceLimitParameter() {
                ParameterDeclaration parameter = new ParameterDeclaration("maxItemsPerPoll");
                parameter.setDescription("Limits the amount of items per poll. ");
                parameter.setRequired(false);
                parameter.setType(BaseTypeBuilder.create(MetadataFormat.JAVA).numberType().integer().range(1, null).build(), false);
                parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                parameter.addModelProperty(new SyntheticModelModelProperty());
                parameter.addModelProperty(new SinceMuleVersionModelProperty(PollingSourceDeclarationEnricher.POLLING_SOURCE_LIMIT_MULE_VERSION));
                parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                return parameter;
            }

            private ParameterDeclaration declareSchedulingStrategyParameter(ClassTypeLoader loader) {
                ParameterDeclaration parameter = new ParameterDeclaration("schedulingStrategy");
                parameter.setDescription("Configures the scheduler that triggers the polling");
                parameter.setRequired(true);
                parameter.setType(PollingSourceDeclarationEnricher.this.loadSchedulingStrategyType(loader), false);
                parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                parameter.addModelProperty(new InfrastructureParameterModelProperty(this.schedulingStrategyParameterSequence));
                parameter.addModelProperty(new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule")));
                parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
                return parameter;
            }

            @Override
            public void onWalkFinished() {
                if (this.thereArePollingSources && !PollingSourceDeclarationEnricher.this.isSchedulerAlreadyImported((ExtensionDeclaration)this.extensionDeclarer.getDeclaration())) {
                    this.extensionDeclarer.withImportedType(new ImportedTypeModel((ObjectType)PollingSourceDeclarationEnricher.this.loadSchedulingStrategyType(extensionLoadingContext.getTypeLoader())));
                }
            }
        });
    }

    private MetadataType loadSchedulingStrategyType(ClassTypeLoader loader) {
        return loader.load((Type)((Object)SchedulingStrategy.class));
    }

    private boolean isSchedulerAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isScheduler(model.getImportedType()));
    }

    private boolean isScheduler(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> SchedulingStrategy.class.getName().equals(typeId)).isPresent();
    }

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }
}

