/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.module.artifact.internal.classloader.WithAttachedClassLoaders;
import org.mule.runtime.module.extension.internal.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class TypeAwareConfigurationFactory
implements ConfigurationFactory {
    private final LazyValue<Class<?>> configurationType;
    private final ClassLoader extensionClassLoader;

    public TypeAwareConfigurationFactory(Class<?> configurationType, ClassLoader extensionClassLoader, boolean addAnnotationsToClass) {
        Objects.requireNonNull(configurationType, "configuration type cannot be null");
        Objects.requireNonNull(extensionClassLoader, "extensionClassLoader type cannot be null");
        IntrospectionUtils.checkInstantiable(configurationType, new ReflectionCache());
        this.extensionClassLoader = extensionClassLoader;
        this.configurationType = new LazyValue<Supplier<Class>>(() -> {
            if (!addAnnotationsToClass) {
                return configurationType;
            }
            return ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> {
                Class annotated = AnnotatedObjectInvocationHandler.addAnnotationsToClass(configurationType);
                if (extensionClassLoader instanceof WithAttachedClassLoaders) {
                    ((WithAttachedClassLoaders)((Object)extensionClassLoader)).attachClassLoader(annotated.getClassLoader().getParent() != null ? annotated.getClassLoader().getParent() : annotated.getClassLoader());
                }
                return annotated;
            });
        });
    }

    @Override
    public Object newInstance() {
        try {
            return ClassUtils.withContextClassLoader(this.extensionClassLoader, this.configurationType.get()::newInstance);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not instantiate configuration of type " + this.configurationType.get().getName()), (Throwable)e);
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.configurationType.get();
    }
}

