/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaValueProviderFactory;
import org.mule.runtime.module.extension.internal.loader.validator.AbstractValueProviderModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class JavaValueProviderModelValidator
extends AbstractValueProviderModelValidator<JavaValueProviderModelValidationContext> {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        ValueProvidersIdValidator valueProvidersIdValidator = new ValueProvidersIdValidator(problemsReporter);
        this.doValidate(model, problemsReporter, new JavaValueProviderModelValidationContext(new ReflectionCache(), valueProvidersIdValidator));
        valueProvidersIdValidator.validateIdsAreUnique();
    }

    @Override
    protected String getProviderId(ValueProviderFactoryModelProperty modelProperty, ValueProviderModel valueProviderModel) {
        JavaValueProviderFactory javaValueProviderFactory = (JavaValueProviderFactory)modelProperty.getFactory();
        Class<?> valueProvider = javaValueProviderFactory.getResolverClass();
        return valueProvider.getSimpleName();
    }

    @Override
    protected void doValidateProvider(ParameterizedModel containerModel, ValueProviderFactoryModelProperty modelProperty, ValueProviderModel valueProviderModel, ProblemsReporter problemsReporter, JavaValueProviderModelValidationContext validationContext) {
        super.doValidateProvider(containerModel, modelProperty, valueProviderModel, problemsReporter, validationContext);
        JavaValueProviderFactory javaValueProviderFactory = (JavaValueProviderFactory)modelProperty.getFactory();
        Class<?> valueProvider = javaValueProviderFactory.getResolverClass();
        String providerName = valueProvider.getSimpleName();
        validationContext.valueProvidersIdValidator.addValueProviderInformation(new ValueProviderInformation(valueProviderModel, containerModel, valueProvider.getName()));
        if (!IntrospectionUtils.isInstantiable(valueProvider, validationContext.reflectionCache)) {
            problemsReporter.addError(new Problem(containerModel, String.format("The Value Provider [%s] is not instantiable but it should", providerName)));
        }
    }

    @Override
    protected void doValidateInjectableParameters(ParameterizedModel containerModel, String containerName, String containerTypeName, Map<String, MetadataType> containerParameterTypesByName, ValueProviderFactoryModelProperty modelProperty, ValueProviderModel valueProviderModel, ProblemsReporter problemsReporter, JavaValueProviderModelValidationContext validationContext) {
        JavaValueProviderFactory javaValueProviderFactory = (JavaValueProviderFactory)modelProperty.getFactory();
        Class<?> valueProvider = javaValueProviderFactory.getResolverClass();
        String providerName = valueProvider.getSimpleName();
        Map<String, String> containerParameterAliases = this.getContainerParameterNames(containerModel.getAllParameterModels());
        Map<String, MetadataType> targetParameterTypesByName = javaValueProviderFactory.getFieldTypesByName();
        for (ActingParameterModel parameterInfo : valueProviderModel.getParameters()) {
            Class gotType;
            MetadataType metadataType;
            Class expectedType;
            String parameterName = containerParameterAliases.get(parameterInfo.getName());
            if (!parameterInfo.getExtractionExpression().equals(parameterName) || (expectedType = ExtensionMetadataTypeUtils.getType(metadataType = containerParameterTypesByName.get(parameterName)).orElseThrow(() -> new IllegalStateException(String.format("Unable to get Class for parameter: %s", parameterName)))).equals(gotType = ExtensionMetadataTypeUtils.getType(targetParameterTypesByName.get(parameterInfo.getName())).orElseThrow(() -> new IllegalStateException(String.format("Unable to get Class for parameter: %s", parameterName))))) continue;
            problemsReporter.addError(new Problem(containerModel, String.format("The Value Provider [%s] defines a parameter '%s' of type '%s' but in the %s '%s' is of type '%s'", providerName, parameterName, gotType, containerTypeName, containerName, expectedType)));
        }
    }

    private Map<String, String> getContainerParameterNames(List<ParameterModel> allParameters) {
        HashMap<String, String> parameterNames = new HashMap<String, String>();
        for (ParameterModel parameterDeclaration : allParameters) {
            parameterNames.put(IntrospectionUtils.getImplementingName(parameterDeclaration), parameterDeclaration.getName());
        }
        return parameterNames;
    }

    private static final class ValueProvidersIdValidator {
        private final Map<String, ValueProviderInformation> valueProvidersImplementationToInformation = new HashMap<String, ValueProviderInformation>();
        private final MultiMap<String, String> valueProvidersIdToImplementations = new MultiMap();
        private final ProblemsReporter problemsReporter;

        public ValueProvidersIdValidator(ProblemsReporter problemsReporter) {
            this.problemsReporter = problemsReporter;
        }

        public void addValueProviderInformation(ValueProviderInformation valueProviderInformation) {
            String valueProviderImplementation = valueProviderInformation.getImplementationClassName();
            if (!this.valueProvidersImplementationToInformation.containsKey(valueProviderImplementation)) {
                this.valueProvidersImplementationToInformation.put(valueProviderImplementation, valueProviderInformation);
                this.valueProvidersIdToImplementations.put(valueProviderInformation.getValueProviderModel().getProviderId(), valueProviderImplementation);
            }
        }

        public void validateIdsAreUnique() {
            this.valueProvidersIdToImplementations.keySet().forEach(valueProviderId -> {
                List<String> valueProviderImplementations = this.valueProvidersIdToImplementations.getAll(valueProviderId);
                if (valueProviderImplementations.size() > 1) {
                    String firstValueProviderImplementation = valueProviderImplementations.get(0);
                    ValueProviderInformation valueProviderInformation = this.valueProvidersImplementationToInformation.get(firstValueProviderImplementation);
                    this.problemsReporter.addError(new Problem(valueProviderInformation.getOwnerModel(), String.format("The following ValueProvider implementations [%s] use the same id [%s]. ValueProvider ids must be unique.", String.join((CharSequence)", ", valueProviderImplementations), valueProviderId)));
                }
            });
        }
    }

    public record JavaValueProviderModelValidationContext(ReflectionCache reflectionCache, ValueProvidersIdValidator valueProvidersIdValidator) implements AbstractValueProviderModelValidator.ValidationContext
    {
    }

    private static final class ValueProviderInformation {
        private final ValueProviderModel valueProviderModel;
        private final ParameterizedModel ownerModel;
        private final String implementationClassName;

        public ValueProviderInformation(ValueProviderModel valueProviderModel, ParameterizedModel ownerModel, String implementationClassName) {
            this.valueProviderModel = valueProviderModel;
            this.ownerModel = ownerModel;
            this.implementationClassName = implementationClassName;
        }

        public ValueProviderModel getValueProviderModel() {
            return this.valueProviderModel;
        }

        public ParameterizedModel getOwnerModel() {
            return this.ownerModel;
        }

        public String getImplementationClassName() {
            return this.implementationClassName;
        }
    }
}

