/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.module.deployment.internal.util.zip.ZipUtils;

public class ArtifactFileWriter {
    private static final String JAR = ".jar";
    private File folder;

    public ArtifactFileWriter(File folder) {
        this.folder = folder;
    }

    public File explodeJarContent(String artifactName, File artifactContentLocation) {
        if (!artifactContentLocation.getAbsolutePath().toString().toLowerCase().endsWith(JAR)) {
            throw new IllegalArgumentException("Artifact content should be a jar, actual: " + artifactContentLocation.getAbsolutePath());
        }
        File directory = new File(this.folder, artifactName);
        directory.deleteOnExit();
        File jarFile = artifactContentLocation;
        try {
            ZipUtils.unzip(jarFile, directory);
            return directory;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while doing unzip of artifact '" + artifactContentLocation.getAbsolutePath() + "'", e);
        }
    }

    public File writeContent(String artifactName, File artifactContentLocation) {
        File artifactFolder = new File(this.folder, artifactName);
        boolean appFolderCreated = artifactFolder.mkdir();
        if (!appFolderCreated) {
            throw new UncheckedIOException("Error while creating a folder to copy artifact content: " + String.valueOf(artifactContentLocation), new IOException("Cannot create folder: " + String.valueOf(artifactFolder)));
        }
        artifactFolder.deleteOnExit();
        try {
            Files.walkFileTree(artifactContentLocation.toPath(), new CopyDirVisitor(artifactContentLocation.toPath(), artifactFolder.toPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while copying content of application from: " + String.valueOf(artifactContentLocation), e);
        }
        return artifactFolder;
    }

    public File writeContent(String artifactName, byte[] zipContent) {
        File artifactFolder = new File(this.folder, artifactName);
        boolean artifactFolderCreated = artifactFolder.mkdir();
        if (!artifactFolderCreated) {
            throw new UncheckedIOException("Error while creating a folder for artifact: " + artifactName, new IOException("Cannot create folder: " + String.valueOf(artifactFolder)));
        }
        artifactFolder.deleteOnExit();
        this.write(artifactName, zipContent, artifactFolder);
        return artifactFolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(String artifactName, byte[] zipContent, File directory) {
        File jarFile = null;
        try {
            jarFile = new File(this.folder, artifactName + JAR);
            FileUtils.writeByteArrayToFile((File)jarFile, (byte[])zipContent);
            ZipUtils.unzip(jarFile, directory);
            if (jarFile == null) return;
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException("Error while doing unzip of artifact '" + artifactName + "'", e);
            }
            catch (Throwable throwable) {
                if (jarFile == null) throw throwable;
                FileUtils.deleteQuietly(jarFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)jarFile);
        return;
    }

    private class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private Path fromPath;
        private Path toPath;
        private StandardCopyOption copyOption = StandardCopyOption.REPLACE_EXISTING;

        public CopyDirVisitor(Path fromPath, Path toPath) {
            this.fromPath = fromPath;
            this.toPath = toPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOption);
            return FileVisitResult.CONTINUE;
        }
    }
}

