/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.impl;

import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleLicenseInterrupter {
    protected static Logger logger = LoggerFactory.getLogger(MuleLicenseInterrupter.class);
    public static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    private static final String INVALID_LICENSE_MESSAGE = "Invalid license";
    private static final String WRAPPER_MANAGER_CLASS_NAME = "org.tanukisoftware.wrapper.WrapperManager";
    private static final int INTERRUPTION_EXIT_CODE = -1;
    private static ScheduledExecutorService scheduledThreadPool;
    private static AtomicBoolean interruptionScheduled;

    public static void interrupt(Exception originalException) {
        if (System.getProperty(TESTING_MODE_PROPERTY_NAME) == null) {
            MuleLicenseInterrupter.interruptNow(originalException);
        } else {
            MuleLicenseInterrupter.interruptDeferred();
        }
    }

    public static boolean isTestingModeTriggered() {
        return System.getProperty(TESTING_MODE_PROPERTY_NAME) != null && interruptionScheduled.get();
    }

    private static void interruptNow(Exception originalException) {
        throw new RuntimeException(INVALID_LICENSE_MESSAGE, originalException);
    }

    private static void interruptDeferred() {
        int time = 12;
        TimeUnit unit = TimeUnit.HOURS;
        if (interruptionScheduled.compareAndSet(false, true)) {
            MuleLicenseInterrupter.getExecutor().schedule(new InterrupterRunnable(), (long)time, unit);
        }
    }

    private static ScheduledExecutorService getExecutor() {
        if (scheduledThreadPool == null) {
            scheduledThreadPool = Executors.newScheduledThreadPool(1, runnable -> new Thread(runnable, "[LicenseManager]"));
        }
        return scheduledThreadPool;
    }

    public static void dispose() {
        if (scheduledThreadPool != null) {
            scheduledThreadPool.shutdownNow();
        }
    }

    static {
        interruptionScheduled = new AtomicBoolean(false);
    }

    private static final class InterrupterRunnable
    implements Runnable {
        private InterrupterRunnable() {
        }

        @Override
        public void run() {
            this.stopContainer();
        }

        private boolean isStandalone() {
            String muleHome = System.getProperty("mule.home");
            return muleHome != null;
        }

        private void stopContainer() {
            try {
                Class<?> clazz = Class.forName(MuleLicenseInterrupter.WRAPPER_MANAGER_CLASS_NAME);
                if (clazz != null) {
                    Method method = clazz.getMethod("stop", Integer.class);
                    method.invoke(clazz.newInstance(), new Integer(-1));
                    return;
                }
                MuleLicenseInterrupter.dispose();
            }
            catch (Exception e) {
                logger.error(MuleLicenseInterrupter.INVALID_LICENSE_MESSAGE);
                System.exit(-1);
            }
        }
    }
}

