/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.impl;

import com.mulesoft.licm.impl.TrueLicenseHelper;
import com.mulesoft.licm.impl.TrueLicenseKeyname;
import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.DefaultKeyStoreParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.ftp.LicenseParam;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleLicenseKeyParam
implements LicenseParam {
    private static final String MULESOFT = "MuleSoft";
    private static final String SUPPORT_EMAIL_ADDR = "support@mulesoft.com";
    public static final String MULESOFT_SUPPORT = "MuleSoft Support";
    private static final String MULE_HOME_ENV_VAR = "%MULE_HOME%";
    private static final String MULE_HOME_PROPERTY = "mule.home";
    private static final String CONF_DIR = "conf";
    private static final String MULE_BASE_ENV_VAR = "%MULE_BASE%";
    private static final String MULE_BASE_PROPERTY = "mule.base";
    private static final Logger logger = LoggerFactory.getLogger(MuleLicenseKeyParam.class);
    private static final int THIRTY_DAY_EVALUATION = 30;
    private final String subject;
    private final Preferences preferences;
    private final KeyStoreParam keyStoreParam;
    private final CipherParam cipherParam;
    private final KeyStoreParam ftpKeyStoreParam;

    public MuleLicenseKeyParam(String subject, Preferences preferences, KeyStoreParam keyStoreParam, CipherParam cipherParam) {
        this.subject = subject;
        this.preferences = preferences;
        this.keyStoreParam = keyStoreParam;
        this.cipherParam = cipherParam;
        this.ftpKeyStoreParam = new DefaultKeyStoreParam(this.getClass(), TrueLicenseHelper.PUBLIC_KEYSTORE, TrueLicenseHelper.EVAL_ALIAS, TrueLicenseHelper.STORE_PASSWORD, TrueLicenseHelper.KEY_PASSWORD);
    }

    public String getSubject() {
        return this.subject;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public KeyStoreParam getKeyStoreParam() {
        return this.keyStoreParam;
    }

    public CipherParam getCipherParam() {
        return this.cipherParam;
    }

    public LicenseContent createFTPLicenseContent() {
        LicenseContent content = new LicenseContent();
        content.setSubject(this.subject);
        X500Principal licenseHolder = this.getContactDetails();
        content.setHolder(licenseHolder);
        X500Principal licenseIssuer = TrueLicenseHelper.getIssuerDetails();
        content.setIssuer(licenseIssuer);
        content.setIssued(new Date());
        return content;
    }

    public int getFTPDays() {
        return 30;
    }

    public KeyStoreParam getFTPKeyStoreParam() {
        return this.ftpKeyStoreParam;
    }

    public void ftpGranted(LicenseContent licenseContent) {
        Preferences preferences = this.getPreferences().node(TrueLicenseKeyname.COM_MULESOFT_LICM.getValue());
        try {
            preferences.flush();
            logger.debug("Created 30 day FTP evaluation license as no existing license file was found");
        }
        catch (Exception e) {
            logger.error("Error creating FTP license");
        }
    }

    public boolean isFTPEligible() {
        File muleBaseConf = this.lookupMuleBaseConf();
        return new File(muleBaseConf, TrueLicenseHelper.EVAL_MARKER_FILE).exists();
    }

    public void removeFTPEligibility() {
        File muleBaseConf = this.lookupMuleBaseConf();
        boolean success = new File(muleBaseConf, TrueLicenseHelper.EVAL_MARKER_FILE).delete();
        if (!success) {
            logger.warn("Couldn't delete eval marker file!");
        }
    }

    private X500Principal getContactDetails() {
        X500Principal contactDetails = null;
        StringBuffer dnBuffer = new StringBuffer();
        dnBuffer.append("CN=").append(MULESOFT_SUPPORT).append(", ");
        dnBuffer.append("OU=").append(MULESOFT_SUPPORT).append(", ");
        dnBuffer.append("O=").append(MULESOFT).append(", ");
        dnBuffer.append("UID=").append(SUPPORT_EMAIL_ADDR).append(", ");
        dnBuffer.append("L=").append(SUPPORT_EMAIL_ADDR).append(", ");
        dnBuffer.append("C=").append("US");
        String contactName = new String(dnBuffer);
        contactDetails = new X500Principal(contactName);
        return contactDetails;
    }

    private File lookupMuleBaseConf() {
        File muleHome = null;
        String muleHomeVar = System.getProperty(MULE_HOME_PROPERTY);
        if (muleHomeVar != null && !muleHomeVar.trim().equals("") && !muleHomeVar.equals(MULE_HOME_ENV_VAR)) {
            try {
                muleHome = new File(muleHomeVar).getCanonicalFile();
            }
            catch (IOException e) {
                logger.error("Problem with mule.home!", (Throwable)e);
            }
        }
        if (muleHome == null || !muleHome.exists() || !muleHome.isDirectory()) {
            logger.debug("mule.home does not exist, defaulting to ./");
            muleHome = new File("." + File.separator);
        }
        File muleBase = null;
        File muleBaseConf = null;
        String muleBaseVar = System.getProperty(MULE_BASE_PROPERTY);
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals(MULE_BASE_ENV_VAR)) {
            try {
                muleBase = new File(muleBaseVar).getCanonicalFile();
            }
            catch (IOException e) {
                logger.error("Problem with mule.base!", (Throwable)e);
            }
        }
        if (muleBase == null) {
            muleBase = muleHome;
        }
        muleBaseConf = new File(muleBase, CONF_DIR);
        return muleBaseConf;
    }
}

