/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.api.license;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.impl.MuleLicenseKey;
import com.mulesoft.mule.runtime.core.api.license.MuleLicense;
import com.mulesoft.mule.runtime.core.api.license.NoValidLicenseFoundException;
import org.mule.runtime.module.reboot.MuleContainerBootstrap;

public class MuleLicenseUtils {
    private static final String MULE_EE_LICENSE = "mule-ee";

    private MuleLicenseUtils() {
    }

    public static MuleLicense getLicense() throws NoValidLicenseFoundException {
        return MuleContainerBootstrap.isBypassLicenseCheck() ? MuleLicenseUtils.getDefaultEvaluationLicense() : MuleLicenseUtils.getInstalledLicense();
    }

    private static MuleLicense getInstalledLicense() throws NoValidLicenseFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(MuleLicenseUtils.class.getClassLoader());
            EnterpriseLicenseKey licenseKey = LicenseManagementFactory.getInstance().createLicenseManager(MULE_EE_LICENSE).validate(MULE_EE_LICENSE);
            MuleLicense muleLicense = new MuleLicense(licenseKey);
            return muleLicense;
        }
        catch (Exception exception) {
            throw new NoValidLicenseFoundException("Invalid EE license");
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static MuleLicense getDefaultEvaluationLicense() {
        try {
            MuleLicense installedLicense = MuleLicenseUtils.getInstalledLicense();
            return installedLicense;
        }
        catch (Exception exception) {
            MuleLicenseKey muleLicenseKey = new MuleLicenseKey();
            muleLicenseKey.setEvaluation(true);
            return new MuleLicense(muleLicenseKey);
        }
    }
}

