/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.config.scheduler;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Supplier;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.core.internal.config.preferred.Preferred;

@Preferred
public class SchedulerPoolsArtifactConfig
extends AbstractComponent
implements SchedulerPoolsConfigFactory,
SchedulerPoolsConfig {
    private final String threadNamePrefix;
    private final long gracefulShutdownTimeout;
    private final SchedulerPoolStrategy poolStrategy;
    private final IoPoolConfig uberPoolConfig;
    private final CpuLightPoolConfig cpuLightPoolConfig;
    private final IoPoolConfig ioPoolConfig;
    private final CpuIntensivePoolConfig cpuIntensivePoolConfig;

    public SchedulerPoolsArtifactConfig(String threadNamePrefix, long gracefulShutdownTimeout, SchedulerPoolStrategy poolStrategy, IoPoolConfig uberPoolConfig, CpuLightPoolConfig cpuLightPoolConfig, IoPoolConfig ioPoolConfig, CpuIntensivePoolConfig cpuIntensivePoolConfig) {
        this.threadNamePrefix = threadNamePrefix;
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.poolStrategy = poolStrategy;
        this.uberPoolConfig = uberPoolConfig;
        this.cpuLightPoolConfig = cpuLightPoolConfig;
        this.ioPoolConfig = ioPoolConfig;
        this.cpuIntensivePoolConfig = cpuIntensivePoolConfig;
    }

    @Override
    public OptionalLong getGracefulShutdownTimeout() {
        return OptionalLong.of(this.gracefulShutdownTimeout);
    }

    private <T> OptionalInt optionalInt(T object, Supplier<Integer> supplier) {
        if (object != null) {
            return OptionalInt.of(supplier.get());
        }
        return OptionalInt.empty();
    }

    private <T> OptionalLong optionalLong(T object, Supplier<Long> supplier) {
        if (object != null) {
            return OptionalLong.of(supplier.get());
        }
        return OptionalLong.empty();
    }

    @Override
    public OptionalInt getCpuLightPoolSize() {
        return this.optionalInt(this.cpuLightPoolConfig, () -> this.cpuLightPoolConfig.getPoolSize());
    }

    @Override
    public OptionalInt getCpuLightQueueSize() {
        return this.optionalInt(this.cpuLightPoolConfig, () -> this.cpuLightPoolConfig.getQueueSize());
    }

    @Override
    public OptionalInt getIoCorePoolSize() {
        return this.optionalInt(this.ioPoolConfig, () -> this.ioPoolConfig.getCorePoolSize());
    }

    @Override
    public OptionalInt getIoMaxPoolSize() {
        return this.optionalInt(this.ioPoolConfig, () -> this.ioPoolConfig.getMaxPoolSize());
    }

    @Override
    public OptionalInt getIoQueueSize() {
        return this.optionalInt(this.ioPoolConfig, () -> this.ioPoolConfig.getQueueSize());
    }

    @Override
    public OptionalLong getIoKeepAlive() {
        return this.optionalLong(this.ioPoolConfig, () -> this.ioPoolConfig.getKeepAlive());
    }

    @Override
    public OptionalInt getCpuIntensivePoolSize() {
        return this.optionalInt(this.cpuIntensivePoolConfig, () -> this.cpuIntensivePoolConfig.getPoolSize());
    }

    @Override
    public OptionalInt getCpuIntensiveQueueSize() {
        return this.optionalInt(this.cpuIntensivePoolConfig, () -> this.cpuIntensivePoolConfig.getQueueSize());
    }

    @Override
    public SchedulerPoolStrategy getSchedulerPoolStrategy() {
        return this.poolStrategy;
    }

    @Override
    public OptionalInt getUberCorePoolSize() {
        return this.optionalInt(this.uberPoolConfig, () -> this.uberPoolConfig.getCorePoolSize());
    }

    @Override
    public OptionalInt getUberMaxPoolSize() {
        return this.optionalInt(this.uberPoolConfig, () -> this.uberPoolConfig.getMaxPoolSize());
    }

    @Override
    public OptionalInt getUberQueueSize() {
        return this.optionalInt(this.uberPoolConfig, () -> this.uberPoolConfig.getQueueSize());
    }

    @Override
    public OptionalLong getUberKeepAlive() {
        return this.optionalLong(this.uberPoolConfig, () -> this.uberPoolConfig.getKeepAlive());
    }

    @Override
    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    @Override
    public Optional<SchedulerPoolsConfig> getConfig() {
        return Optional.of(this);
    }

    public CpuLightPoolConfig getCpuLightPoolConfig() {
        return this.cpuLightPoolConfig;
    }

    public IoPoolConfig getIoPoolConfig() {
        return this.ioPoolConfig;
    }

    public IoPoolConfig getUberPoolConfig() {
        return this.uberPoolConfig;
    }

    public CpuIntensivePoolConfig getCpuIntensivePoolConfig() {
        return this.cpuIntensivePoolConfig;
    }

    public static class CpuIntensivePoolConfig {
        private int poolSize;
        private int queueSize;

        public int getPoolSize() {
            return this.poolSize;
        }

        public void setPoolSize(int poolSize) {
            this.poolSize = poolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }

    public static class CpuLightPoolConfig {
        private int poolSize;
        private int queueSize;

        public int getPoolSize() {
            return this.poolSize;
        }

        public void setPoolSize(int poolSize) {
            this.poolSize = poolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }

    public static class IoPoolConfig {
        private int corePoolSize;
        private int maxPoolSize;
        private int queueSize;
        private long keepAlive;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public long getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(long keepAlive) {
            this.keepAlive = keepAlive;
        }
    }
}

