/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.streaming.bytes;

import com.mulesoft.mule.runtime.core.internal.streaming.bytes.Range;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.ManagedByteBufferWrapper;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.streaming.TempBufferFileUtils;
import org.mule.runtime.core.internal.streaming.bytes.AbstractInputStreamBuffer;
import org.mule.runtime.core.internal.streaming.bytes.FileStoreCursorStreamConfig;

public class FileStoreInputStreamBuffer
extends AbstractInputStreamBuffer {
    private final ManagedByteBufferWrapper[] managedBufferBuckets;
    private final ByteBuffer[] bufferBuckets;
    private final Lock fileStoreLock = new ReentrantLock();
    private int maxInMemorySize;
    private final int bucketSize;
    private final LazyValue<Pair<File, RandomAccessFile>> fileStore;
    private Range rollingBufferRange;
    private int bufferLoad = 0;
    private int topBucketIndex = 0;
    private long fileStoreTopPosition = 0L;

    public FileStoreInputStreamBuffer(InputStream stream, FileStoreCursorStreamConfig config, ByteBufferManager bufferManager) {
        super(stream, bufferManager);
        this.maxInMemorySize = config.getMaxInMemorySize().toBytes();
        this.bucketSize = config.getBucketSize();
        this.managedBufferBuckets = new ManagedByteBufferWrapper[config.getBucketsCount()];
        this.bufferBuckets = new ByteBuffer[config.getBucketsCount()];
        this.rollingBufferRange = new Range(0L, this.maxInMemorySize);
        this.fileStore = this.createFileStore();
    }

    protected LazyValue<Pair<File, RandomAccessFile>> createFileStore() {
        return new LazyValue<Supplier<Pair>>(() -> {
            File bufferFile = TempBufferFileUtils.createBufferFile("stream-buffer");
            try {
                return new Pair<File, RandomAccessFile>(bufferFile, new RandomAccessFile(bufferFile, "rw"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(String.format("Buffer file %s was just created but now it doesn't exist", bufferFile.getAbsolutePath()));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ByteBuffer doGet(long position, int length) {
        Range requiredRange = new Range(position, position + (long)length);
        this.readLock.lock();
        try {
            ByteBuffer current = this.getFromCurrentData(requiredRange, length);
            if (current != null) {
                ByteBuffer byteBuffer = current;
                return byteBuffer;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            ByteBuffer refetch = this.getFromCurrentData(requiredRange, length);
            if (refetch != null) {
                ByteBuffer byteBuffer = refetch;
                return byteBuffer;
            }
            do {
                if (this.streamFullyConsumed) {
                    return null;
                }
                int read = this.consumeForwardData();
                if (read >= 0) continue;
                return null;
            } while ((refetch = this.getFromCurrentData(requiredRange, length)) == null);
            ByteBuffer byteBuffer = refetch;
            return byteBuffer;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception found while consuming stream"), (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private ByteBuffer getFromCurrentData(Range requiredRange, int length) {
        long requiredStart = requiredRange.getStart();
        if (requiredRange.isBehind(this.rollingBufferRange) && this.fileStoreTopPosition > requiredStart) {
            return this.getBackwardsData(requiredRange, length);
        }
        if (requiredStart < this.rollingBufferRange.getStart() && this.fileStoreTopPosition > requiredStart) {
            requiredRange = new Range(requiredStart, requiredStart + Math.min((long)length, this.fileStoreTopPosition - requiredStart));
            return this.getBackwardsData(requiredRange, Math.min(length, requiredRange.length()));
        }
        if (this.rollingBufferRange.contains(requiredRange) && this.rollingBufferRange.getStart() + (long)this.bufferLoad > requiredStart) {
            long startCopyPosition = requiredStart - this.rollingBufferRange.getStart();
            return this.copy(startCopyPosition, Math.toIntExact(Math.min((long)length, (long)this.bufferLoad - startCopyPosition)));
        }
        Range overlap = this.rollingBufferRange.overlap(requiredRange, this.bufferLoad);
        if (overlap != null) {
            return this.copy(overlap.getStart() - this.rollingBufferRange.getStart(), overlap.length());
        }
        return null;
    }

    private ByteBuffer getBackwardsData(Range requiredRange, int length) {
        this.fileStoreLock.lock();
        try {
            RandomAccessFile fileStore = this.fileStore.get().getSecond();
            fileStore.seek(requiredRange.getStart());
            ByteBuffer buffer = ByteBuffer.allocate(length);
            int bytesRead = fileStore.read(buffer.array(), 0, length);
            if (bytesRead > 0) {
                buffer.limit(bytesRead);
                ByteBuffer byteBuffer = buffer;
                return byteBuffer;
            }
            return null;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not read from file store"), (Throwable)e);
        }
        finally {
            this.fileStoreLock.unlock();
        }
    }

    private void recycleRollingBuffer() {
        this.persistInFileStore(true);
        this.bufferLoad = 0;
        this.topBucketIndex = 0;
        this.rollingBufferRange = this.rollingBufferRange.advance(this.maxInMemorySize);
    }

    @Override
    public int consumeForwardData() throws IOException {
        return this.consumeForwardData(true);
    }

    private int consumeForwardData(boolean recycleIfOverflow) throws IOException {
        int result;
        if (this.bufferLoad >= this.maxInMemorySize) {
            if (recycleIfOverflow) {
                this.recycleRollingBuffer();
            } else {
                return -1;
            }
        }
        boolean createNewBucket = false;
        ByteBuffer bucket = this.bufferBuckets[this.topBucketIndex];
        if (bucket == null) {
            createNewBucket = true;
        } else if (bucket.limit() == bucket.capacity()) {
            ++this.topBucketIndex;
            if (this.topBucketIndex == this.bufferBuckets.length) {
                this.recycleRollingBuffer();
            }
            createNewBucket = true;
        }
        if (createNewBucket) {
            ManagedByteBufferWrapper managedBucket = this.bufferManager.allocateManaged(this.bucketSize);
            bucket = managedBucket.getDelegate();
            this.managedBufferBuckets[this.topBucketIndex] = managedBucket;
            this.bufferBuckets[this.topBucketIndex] = bucket;
        }
        int limit = bucket.limit();
        int position = bucket.position();
        bucket.limit(bucket.capacity());
        if (limit != bucket.capacity()) {
            bucket.position(limit);
        }
        if ((result = this.consumeStream(bucket)) >= 0) {
            bucket.flip();
            this.bufferLoad += result;
        } else {
            bucket.limit(limit);
            bucket.position(position);
        }
        return result;
    }

    @Override
    protected ByteBuffer copy(long position, int length) {
        int offset;
        int bucketIndex = (int)position / this.bucketSize;
        ByteBuffer b = this.bufferBuckets[bucketIndex];
        if (b == null) {
            try {
                if (this.consumeForwardData(false) <= 0) {
                    return null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            b = this.bufferBuckets[bucketIndex];
        }
        if ((offset = Math.toIntExact(position) - bucketIndex * this.bucketSize) == b.limit()) {
            return null;
        }
        if (this.streamFullyConsumed && offset + length < b.limit()) {
            return ByteBuffer.wrap(b.array(), offset, Math.min(length, b.limit() - offset)).slice();
        }
        byte[] copy = new byte[length];
        int copied = Math.min(length, b.limit() - offset);
        System.arraycopy(b.array(), offset, copy, 0, copied);
        ++bucketIndex;
        while (bucketIndex < this.bufferBuckets.length && copied < length) {
            b = this.bufferBuckets[bucketIndex];
            if (!this.isActiveBucket(b)) break;
            int len = Math.min(length - copied, b.limit());
            System.arraycopy(b.array(), 0, copy, copied, len);
            copied += len;
            ++bucketIndex;
        }
        return ByteBuffer.wrap(copy, 0, copied);
    }

    private void persistInFileStore(boolean clear) {
        if (this.bufferLoad == 0) {
            return;
        }
        this.fileStoreLock.lock();
        try {
            try {
                RandomAccessFile fileStore = this.fileStore.get().getSecond();
                fileStore.seek(this.fileStoreTopPosition);
                int i = 0;
                while (i < this.bufferBuckets.length) {
                    ByteBuffer b = this.bufferBuckets[i];
                    if (!this.isActiveBucket(b)) {
                        break;
                    }
                    int len = b.limit();
                    this.write(fileStore, b, len);
                    if (clear) {
                        this.managedBufferBuckets[i].release();
                        this.managedBufferBuckets[i] = null;
                        this.bufferBuckets[i] = null;
                    }
                    this.fileStoreTopPosition += (long)len;
                    ++i;
                }
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not write in off-heap file store"), (Throwable)e);
            }
        }
        finally {
            this.fileStoreLock.unlock();
        }
    }

    protected void write(RandomAccessFile fileStore, ByteBuffer b, int len) throws IOException {
        fileStore.write(b.array(), 0, len);
    }

    private boolean isActiveBucket(ByteBuffer b) {
        return b != null;
    }

    @Override
    public void doClose() {
        this.deallocateBuckets();
        if (this.fileStore.isComputed()) {
            Pair<File, RandomAccessFile> filePair = this.fileStore.get();
            IOUtils.closeQuietly(() -> ((RandomAccessFile)filePair.getSecond()).close());
            this.deleteBufferFile(filePair.getFirst());
        }
    }

    protected void deleteBufferFile(File bufferFile) {
        bufferFile.delete();
    }

    private void deallocateBuckets() {
        int i = 0;
        while (i < this.managedBufferBuckets.length) {
            ManagedByteBufferWrapper buffer = this.managedBufferBuckets[i];
            if (buffer == null) {
                return;
            }
            buffer.release();
            ++i;
        }
    }
}

