/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.streaming.bytes;

import org.mule.runtime.api.util.Preconditions;

final class Range {
    private final long start;
    private final long end;

    Range(long start, long end) {
        Preconditions.checkArgument(end >= start, "end has to be greater than start");
        this.start = start;
        this.end = end;
    }

    Range advance(int offset) {
        return new Range(this.end, this.end + (long)offset);
    }

    boolean contains(Range range) {
        return this.start <= range.start && this.end >= range.end;
    }

    boolean isAhead(Range range) {
        return this.start > range.start && this.end >= range.end;
    }

    boolean isBehind(Range range) {
        return this.end < range.end;
    }

    boolean startsAfter(Range range) {
        return this.start > range.end;
    }

    Range overlap(Range range, int bufferLoad) {
        long end;
        long start = Math.max(this.start, range.start);
        if (start < (end = Math.min(this.end, range.end)) && this.start + (long)bufferLoad > start) {
            Range overlap = new Range(start, end);
            return this.contains(overlap) ? overlap : null;
        }
        return null;
    }

    int length() {
        return Math.toIntExact(this.end - this.start);
    }

    boolean isEmpty() {
        return this.start == this.end;
    }

    long getStart() {
        return this.start;
    }

    long getEnd() {
        return this.end;
    }
}

