/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.engine.history;

import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.AbstractComponent;

public class HistoryExpirationCriteria
extends AbstractComponent {
    private final long maxAge;
    private final TimeUnit ageUnit;

    public HistoryExpirationCriteria(long maxAge, TimeUnit ageUnit) {
        this.maxAge = maxAge;
        this.ageUnit = ageUnit;
    }

    public boolean shouldExpire(BatchJobInstance jobInstance) {
        return this.getAge(jobInstance) > this.ageUnit.toMillis(this.maxAge);
    }

    private long getAge(BatchJobInstance jobInstance) {
        return System.currentTimeMillis() - jobInstance.getCreationTime().getTime();
    }
}

