/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.BatchProcessingListenersOwner;
import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;

public class BaseBatchProcessingListenerOwner
implements BatchProcessingListenersOwner {
    private List<BatchProcessingListener> globalListeners = new LinkedList<BatchProcessingListener>();
    private Multimap<String, BatchProcessingListener> listeners = LinkedListMultimap.create();

    @Override
    public void addBatchProcessingListener(BatchProcessingListener listener) {
        this.globalListeners.add(listener);
    }

    @Override
    public void addBatchProcessingListener(BatchJob job, BatchProcessingListener listener) {
        Preconditions.checkArgument(job != null, "Cannot register a listener on an unspecified job");
        Preconditions.checkArgument(listener != null, "Cannot register a null listener");
        this.listeners.put((Object)job.getName(), (Object)listener);
    }

    @Override
    public boolean removeBatchProcessingListener(BatchJob job, BatchProcessingListener listener) {
        return this.listeners.remove((Object)job.getName(), (Object)listener);
    }

    @Override
    public boolean removeBatchProcessingListener(BatchProcessingListener listener) {
        return this.globalListeners.remove(listener);
    }

    protected List<BatchProcessingListener> getListeners(BatchJobInstance jobInstance) {
        Collection instanceListeners = this.listeners.get((Object)jobInstance.getOwnerJobName());
        ArrayList<BatchProcessingListener> all = new ArrayList<BatchProcessingListener>(this.globalListeners.size() + instanceListeners.size());
        all.addAll(this.globalListeners);
        all.addAll(instanceListeners);
        return all;
    }
}

