/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.BatchJobResultAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepResult;
import com.mulesoft.mule.runtime.module.batch.internal.exception.ExceptionSerializationWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultBatchJobResult
implements BatchJobResultAdapter {
    private static final long serialVersionUID = 8915213037073563516L;
    private String batchJodInstanceId;
    private long totalRecords = 0L;
    private long successfulRecords = 0L;
    private long failedRecords = 0L;
    private long loadedRecords = 0L;
    private long processedRecords = 0L;
    private long processStartTime = 0L;
    private long totalRunningTime = 0L;
    private Map<String, DefaultBatchStepResult> batchStepResults = new HashMap<String, DefaultBatchStepResult>();
    private Exception inputPhaseException;
    private Exception loadingPhaseException;
    private Exception onCompletePhaseException;

    public DefaultBatchJobResult(String batchJodInstanceId) {
        this.batchJodInstanceId = batchJodInstanceId;
    }

    @Override
    public void updateFor(BatchJobAdapter job, Collection<Record> records) {
        for (Record record : records) {
            BatchStepAdapter step = job.getStepById(record.getCurrentStepId());
            DefaultBatchStepResult result = (DefaultBatchStepResult)this.getResultForStep(step.getName());
            result.incrementReceivedRecords(1L);
            Exception e = record.getExceptionForStep(step.getName());
            if (e != null) {
                result.incrementFailedRecords(e, 1L);
                if (record.getFailedStepsCount() == 1) {
                    ++this.failedRecords;
                }
            } else {
                result.incrementSuccessfulRecords(1L);
            }
            if (!step.isLast()) continue;
            ++this.processedRecords;
            if (record.hasErrors()) continue;
            ++this.successfulRecords;
        }
    }

    @Override
    public BatchStepResult getResultForStep(String stepId) {
        DefaultBatchStepResult result = this.batchStepResults.get(stepId);
        if (result == null) {
            result = new DefaultBatchStepResult();
            this.batchStepResults.put(stepId, result);
        }
        return result;
    }

    @Override
    public long startClock() {
        this.processStartTime = System.currentTimeMillis();
        return this.processStartTime;
    }

    @Override
    public long stopClock() {
        return this.totalRunningTime += System.currentTimeMillis() - this.processStartTime;
    }

    @Override
    public long getElapsedTimeInMillis() {
        return this.totalRunningTime;
    }

    @Override
    public long getSuccessfulRecords() {
        return this.successfulRecords;
    }

    @Override
    public long getFailedRecords() {
        return this.failedRecords;
    }

    @Override
    public long getProcessedRecords() {
        return this.processedRecords;
    }

    @Override
    public long getTotalRecords() {
        return this.totalRecords;
    }

    @Override
    public String getBatchJobInstanceId() {
        return this.batchJodInstanceId;
    }

    @Override
    public long getLoadedRecords() {
        return this.loadedRecords;
    }

    @Override
    public long incrementLoadedRecords(long howMany) {
        return this.loadedRecords += howMany;
    }

    @Override
    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    @Override
    public boolean isFailedOnInputPhase() {
        return this.inputPhaseException != null;
    }

    @Override
    public Exception getInputPhaseException() {
        return this.inputPhaseException;
    }

    @Override
    public Exception getLoadingPhaseException() {
        return this.loadingPhaseException;
    }

    @Override
    public boolean isFailedOnLoadingPhase() {
        return this.loadingPhaseException != null;
    }

    @Override
    public boolean isFailedOnCompletePhase() {
        return this.onCompletePhaseException != null;
    }

    @Override
    public Exception getOnCompletePhaseException() {
        return this.onCompletePhaseException;
    }

    @Override
    public void setOnCompletePhaseException(Exception onCompleteStepException) {
        this.onCompletePhaseException = new ExceptionSerializationWrapper(onCompleteStepException);
    }

    @Override
    public void setInputPhaseException(Exception inputPhaseException) {
        this.inputPhaseException = new ExceptionSerializationWrapper(inputPhaseException);
    }

    @Override
    public void setLoadingPhaseException(Exception loadingPhaseException) {
        this.loadingPhaseException = new ExceptionSerializationWrapper(loadingPhaseException);
    }

    @Override
    public Map<String, BatchStepResult> getBatchStepResults() {
        return Collections.unmodifiableMap(this.batchStepResults);
    }
}

