/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobInstanceStatus;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceStore;
import com.mulesoft.mule.runtime.module.batch.internal.BaseBatchProcessingListenerOwner;
import com.mulesoft.mule.runtime.module.batch.internal.engine.BatchLockFactory;
import com.mulesoft.mule.runtime.module.batch.internal.engine.LegacyAwareObjectSerializerWrapper;
import com.mulesoft.mule.runtime.module.batch.internal.streaming.SerializerAwareObjectStoreProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.ListConsumer;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.streaming.object.iterator.SimpleConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBatchJobInstanceStore
extends BaseBatchProcessingListenerOwner
implements BatchJobInstanceStore,
MuleContextAware,
Initialisable,
Startable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBatchJobInstanceStore.class);
    private static final String LOCK_PREFIX = String.valueOf(DefaultBatchJobInstanceStore.class.getCanonicalName()) + "-";
    private MuleContext muleContext;
    private ObjectStoreManager objectStoreManager;
    private Collection<BatchJobInstanceAdapter> executingInstances = new HashSet<BatchJobInstanceAdapter>();
    private Map<String, ObjectStore<byte[]>> instanceStores = new ConcurrentHashMap<String, ObjectStore<byte[]>>();
    @Inject
    private BatchEngine batchEngine;
    @Inject
    @Named(value="kryo.serializer")
    private ObjectSerializer serializer;
    @Inject
    private BatchLockFactory lockFactory;

    private ObjectStore<byte[]> getInstanceObjectStore(BatchJobInstance jobInstance) {
        return this.getInstanceObjectStore(jobInstance.getOwnerJobName());
    }

    private ObjectStore<byte[]> getInstanceObjectStore(String jobName) {
        String key = String.format("BATCH-%s-INSTANCE-STORE", jobName);
        return this.instanceStores.computeIfAbsent(key, k -> this.objectStoreManager.createObjectStore(key, ObjectStoreSettings.unmanagedPersistent()));
    }

    @Override
    public void store(BatchJobInstanceAdapter jobInstance) {
        this.doStore(jobInstance, false);
    }

    @Override
    public void update(BatchJobInstanceAdapter jobInstance) {
        this.doStore(jobInstance, true);
    }

    @Override
    public boolean remove(BatchJobInstance jobInstance) {
        ObjectStore<byte[]> store = this.getInstanceObjectStore(jobInstance);
        String key = jobInstance.getId();
        Lock lock = this.getLock(jobInstance);
        lock.lock();
        try {
            if (store.contains(key)) {
                store.remove(key);
            }
            return true;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            return false;
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<Record> getFailedRecords(BatchJobInstanceAdapter jobInstance) {
        Lock lock = this.getLock(jobInstance);
        lock.lock();
        try {
            ObjectStore<byte[]> failedObjectStore = this.getFailedRecordsObjectStore(jobInstance);
            ListConsumer consumer = new ListConsumer(new SerializerAwareObjectStoreProducer(failedObjectStore, this.serializer));
            ConsumerStreamingIterator<Record> consumerStreamingIterator = new ConsumerStreamingIterator<Record>(consumer);
            return consumerStreamingIterator;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clearFailedRecords(BatchJobInstanceAdapter jobInstance) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Removing failed records for instance %s of job %s", jobInstance.getId(), jobInstance.getOwnerJobName()));
        }
        Lock lock = this.getLock(jobInstance);
        lock.lock();
        try {
            ObjectStore<byte[]> failedObjectStore = this.getFailedRecordsObjectStore(jobInstance);
            try {
                failedObjectStore.clear();
            }
            catch (ObjectStoreException e) {
                LOGGER.error(String.format("Could not remove failed records from instace %s of batch job %s", jobInstance.getId(), jobInstance.getOwnerJobName()), (Throwable)e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void storeFailedRecords(BatchJobInstanceAdapter jobInstance, Collection<Record> records) {
        if (records.isEmpty()) {
            return;
        }
        Lock lock = this.getLock(jobInstance);
        lock.lock();
        try {
            try {
                this.getFailedRecordsObjectStore(jobInstance).store(UUID.getUUID(), this.serializer.getInternalProtocol().serialize(records));
            }
            catch (ObjectStoreException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Exception found while flushing %d records of instance %s from job %s to failed records objectStore", records.size(), jobInstance.getId(), jobInstance.getOwnerJobName())), (Throwable)e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExecutionPool(BatchJobInstanceAdapter jobInstance) throws ObjectStoreException {
        Collection<BatchJobInstanceAdapter> collection = this.executingInstances;
        synchronized (collection) {
            this.executingInstances.remove(jobInstance);
            if (jobInstance.getStatus() == BatchJobInstanceStatus.EXECUTING) {
                this.executingInstances.add(jobInstance);
                for (BatchProcessingListener listener : this.getListeners(jobInstance)) {
                    listener.onExecutableStateTransition(jobInstance);
                }
            }
        }
    }

    @Override
    public BatchJobInstanceAdapter getJobInstance(String jobName, String jobInstanceId) {
        Lock lock = this.getLock(jobName);
        lock.lock();
        try {
            BatchJobInstanceAdapter batchJobInstanceAdapter = (BatchJobInstanceAdapter)this.doRetrieve(this.getInstanceObjectStore(jobName), jobInstanceId);
            return batchJobInstanceAdapter;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T extends BatchJobInstance> Iterator<T> getJobInstances(String jobName) {
        Lock lock = this.getLock(jobName);
        lock.lock();
        try {
            ObjectStore<byte[]> objectStore = this.getInstanceObjectStore(jobName);
            SerializerAwareObjectStoreProducer producer = new SerializerAwareObjectStoreProducer(objectStore, this.serializer);
            SimpleConsumer consumer = new SimpleConsumer(producer);
            ConsumerStreamingIterator consumerStreamingIterator = new ConsumerStreamingIterator(consumer);
            return consumerStreamingIterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatchJobInstanceAdapter> getExecutingInstances() throws MuleException {
        Collection<BatchJobInstanceAdapter> collection = this.executingInstances;
        synchronized (collection) {
            return new ArrayList<BatchJobInstanceAdapter>(this.executingInstances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExecutingInstancesCache() {
        Collection<BatchJobInstanceAdapter> collection = this.executingInstances;
        synchronized (collection) {
            this.executingInstances.clear();
            for (BatchJob job : this.batchEngine.getBatchJobs()) {
                Iterator it = this.getJobInstances(job.getName());
                while (it.hasNext()) {
                    BatchJobInstanceAdapter jobInstance = (BatchJobInstanceAdapter)it.next();
                    if (jobInstance.getStatus() != BatchJobInstanceStatus.EXECUTING) continue;
                    this.executingInstances.add(jobInstance);
                }
            }
        }
    }

    private Lock getLock(BatchJobInstance jobInstance) {
        return this.getLock(jobInstance.getOwnerJobName());
    }

    private Lock getLock(String jobName) {
        return this.lockFactory.createLock(String.format("%sBATCH-INSTANCE-LOCK-%s", LOCK_PREFIX, jobName));
    }

    private String getFailedRecordsObjectStoreName(BatchJobInstance jobInstance) {
        return String.format("BATCH-%s-INSTANCE-%s-FAILED-RECORDS", jobInstance.getOwnerJobName(), jobInstance.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doStore(BatchJobInstanceAdapter jobInstance, boolean overwrite) {
        String id = jobInstance.getId();
        ObjectStore<byte[]> store = this.getInstanceObjectStore(jobInstance);
        boolean stateChange = false;
        Lock lock = this.getLock(jobInstance);
        lock.lock();
        try {
            try {
                if (store.contains(id)) {
                    if (!overwrite) throw new IllegalStateException(String.format("Id %s is already present in store", id));
                    BatchJobInstanceAdapter previous = (BatchJobInstanceAdapter)this.serializer.getInternalProtocol().deserialize(store.remove(id));
                    stateChange = previous.getStatus() != jobInstance.getStatus();
                } else {
                    stateChange = true;
                }
                byte[] serialized = this.serializer.getInternalProtocol().serialize(jobInstance);
                store.store(id, serialized);
                this.updateExecutionPool((BatchJobInstanceAdapter)this.serializer.getInternalProtocol().deserialize(serialized));
                return;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(String.format("Could not store job instance %s", id), e);
            }
        }
        finally {
            lock.unlock();
            if (stateChange) {
                this.fireStatusChangeNotification(jobInstance);
            }
        }
    }

    private void fireStatusChangeNotification(BatchJobInstanceAdapter jobInstance) {
        for (BatchProcessingListener listener : this.getListeners(jobInstance)) {
            listener.onJobInstanceStateChange(jobInstance);
        }
    }

    private <T> T doRetrieve(ObjectStore<byte[]> store, String id) {
        try {
            return this.serializer.getInternalProtocol().deserialize(store.retrieve(id));
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            return null;
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(String.format("unexpected exception found retrieving id %s", id), e);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        this.objectStoreManager = ((DefaultMuleContext)this.muleContext).getLocalObjectStoreManager();
        this.serializer = new LegacyAwareObjectSerializerWrapper(this.serializer);
    }

    @Override
    public void start() throws MuleException {
        this.loadExecutingInstancesCache();
    }

    private ObjectStore<byte[]> getFailedRecordsObjectStore(BatchJobInstance jobInstance) {
        return this.objectStoreManager.getOrCreateObjectStore(this.getFailedRecordsObjectStoreName(jobInstance), ObjectStoreSettings.unmanagedPersistent());
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

