/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.api.record.RecordCompletionTracker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.util.Preconditions;

public class RecordCompletableFuture
extends CompletableFuture<Void>
implements RecordCompletionTracker {
    private final CompletableFuture<Void> effectiveFuture;
    private final CompletableFuture<Void> consumersFuture = new CompletableFuture();
    private final AtomicInteger clientCount = new AtomicInteger(1);

    public RecordCompletableFuture() {
        this.effectiveFuture = this.consumersFuture;
    }

    public RecordCompletableFuture(CompletableFuture<Void> dependantCallback) {
        Preconditions.checkArgument(dependantCallback != null, "dependantCallback cannot be null");
        this.effectiveFuture = RecordCompletableFuture.allOf(this.consumersFuture, dependantCallback);
    }

    @Override
    public void incrementConsumers() {
        this.clientCount.addAndGet(1);
    }

    @Override
    public void decrementConsumers() {
        if (this.clientCount.addAndGet(-1) < 1) {
            this.consumersFuture.complete(null);
        }
    }

    @Override
    public boolean isDone() {
        return this.effectiveFuture.isDone();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        return this.effectiveFuture.get();
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.effectiveFuture.get(timeout, unit);
    }

    @Override
    public Void join() {
        return this.effectiveFuture.join();
    }

    @Override
    public Void getNow(Void valueIfAbsent) {
        return this.effectiveFuture.getNow(valueIfAbsent);
    }

    @Override
    public boolean complete(Void value) {
        return this.effectiveFuture.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        return this.effectiveFuture.completeExceptionally(ex);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super Void, ? extends U> fn) {
        return this.effectiveFuture.thenApply(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super Void, ? extends U> fn) {
        return this.effectiveFuture.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super Void, ? extends U> fn, Executor executor) {
        return this.effectiveFuture.thenApplyAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super Void> action) {
        return this.effectiveFuture.thenAccept(action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super Void> action) {
        return this.effectiveFuture.thenAcceptAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super Void> action, Executor executor) {
        return this.effectiveFuture.thenAcceptAsync(action, executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.effectiveFuture.thenRun(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.effectiveFuture.thenRunAsync(action);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.effectiveFuture.thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super Void, ? super U, ? extends V> fn) {
        return this.effectiveFuture.thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super Void, ? super U, ? extends V> fn) {
        return this.effectiveFuture.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super Void, ? super U, ? extends V> fn, Executor executor) {
        return this.effectiveFuture.thenCombineAsync(other, fn, executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super Void, ? super U> action) {
        return this.effectiveFuture.thenAcceptBoth(other, action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super Void, ? super U> action) {
        return this.effectiveFuture.thenAcceptBothAsync(other, action);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super Void, ? super U> action, Executor executor) {
        return this.effectiveFuture.thenAcceptBothAsync(other, action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.effectiveFuture.runAfterBoth((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.effectiveFuture.runAfterBothAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.effectiveFuture.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends Void> other, Function<? super Void, U> fn) {
        return this.effectiveFuture.applyToEither(other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends Void> other, Function<? super Void, U> fn) {
        return this.effectiveFuture.applyToEitherAsync(other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends Void> other, Function<? super Void, U> fn, Executor executor) {
        return this.effectiveFuture.applyToEitherAsync(other, fn, executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends Void> other, Consumer<? super Void> action) {
        return this.effectiveFuture.acceptEither(other, action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends Void> other, Consumer<? super Void> action) {
        return this.effectiveFuture.acceptEitherAsync(other, action);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends Void> other, Consumer<? super Void> action, Executor executor) {
        return this.effectiveFuture.acceptEitherAsync(other, action, executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.effectiveFuture.runAfterEither((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.effectiveFuture.runAfterEitherAsync((CompletionStage)other, action);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.effectiveFuture.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super Void, ? extends CompletionStage<U>> fn) {
        return this.effectiveFuture.thenCompose(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super Void, ? extends CompletionStage<U>> fn) {
        return this.effectiveFuture.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super Void, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.effectiveFuture.thenComposeAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Void> whenComplete(BiConsumer<? super Void, ? super Throwable> action) {
        return this.effectiveFuture.whenComplete(action);
    }

    @Override
    public CompletableFuture<Void> whenCompleteAsync(BiConsumer<? super Void, ? super Throwable> action) {
        return this.effectiveFuture.whenCompleteAsync(action);
    }

    @Override
    public CompletableFuture<Void> whenCompleteAsync(BiConsumer<? super Void, ? super Throwable> action, Executor executor) {
        return this.effectiveFuture.whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super Void, Throwable, ? extends U> fn) {
        return this.effectiveFuture.handle(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super Void, Throwable, ? extends U> fn) {
        return this.effectiveFuture.handleAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super Void, Throwable, ? extends U> fn, Executor executor) {
        return this.effectiveFuture.handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<Void> toCompletableFuture() {
        return this.effectiveFuture.toCompletableFuture();
    }

    @Override
    public CompletableFuture<Void> exceptionally(Function<Throwable, ? extends Void> fn) {
        return this.effectiveFuture.exceptionally(fn);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.effectiveFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.effectiveFuture.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.effectiveFuture.isCompletedExceptionally();
    }

    @Override
    public void obtrudeValue(Void value) {
        this.effectiveFuture.obtrudeValue(value);
    }

    @Override
    public void obtrudeException(Throwable ex) {
        this.effectiveFuture.obtrudeException(ex);
    }

    @Override
    public int getNumberOfDependents() {
        return this.effectiveFuture.getNumberOfDependents();
    }

    @Override
    public String toString() {
        return this.effectiveFuture.toString();
    }
}

