/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.google.common.collect.Multimap;
import com.mulesoft.mule.runtime.module.batch.api.BatchJobResult;
import com.mulesoft.mule.runtime.module.batch.api.notification.BatchNotification;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.queue.BatchQueueManager;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.BatchJobResultAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.InMemoryRecordBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingQueueBuffer
extends InMemoryRecordBuffer {
    private static final String NAME = "BATCH_LOADING_QUEUE_BUFFER";
    private static final Logger logger = LoggerFactory.getLogger(LoadingQueueBuffer.class);
    private BatchQueueManager batchQueueManager;
    private NotificationDispatcher notificationFirer;

    public LoadingQueueBuffer(BatchQueueManager batchQueueManager, int blockSize, NotificationDispatcher notificationFirer) {
        super(NAME, blockSize);
        this.notificationFirer = notificationFirer;
        this.batchQueueManager = batchQueueManager;
    }

    @Override
    protected void doFlush(BatchJobInstanceAdapter jobInstance, Multimap<BatchTransactionContext, Record> records) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading %d records from instance %s of job %s", records.size(), jobInstance.getId(), jobInstance.getOwnerJobName()));
        }
        try {
            for (Map.Entry entry : records.asMap().entrySet()) {
                this.batchQueueManager.steppingQueue(jobInstance).dispatch((BatchTransactionContext)entry.getKey(), new ArrayList<Record>((Collection)entry.getValue()));
                BatchJobResult result = jobInstance.getResult();
                if (result instanceof BatchJobResultAdapter) {
                    ((BatchJobResultAdapter)result).incrementLoadedRecords(records.size());
                }
                this.notificationFirer.dispatch(new BatchNotification(jobInstance, BatchNotification.LOAD_PHASE_PROGRESS));
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Found exception while trying to flush %d records during loading phase for instance %s of job %s", records.size(), jobInstance.getId(), jobInstance.getOwnerJobName())), (Throwable)e);
        }
    }
}

