/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.record;

import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.internal.record.AcceptRecordPolicy;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StringUtils;

public class RecordFilteringStrategy {
    private final AcceptRecordPolicy acceptRecordPolicy;
    private final String filterExpression;
    private final ExpressionManager expressionManager;

    public RecordFilteringStrategy(AcceptRecordPolicy acceptRecordPolicy, String expression, ExpressionManager expressionManager) {
        this.acceptRecordPolicy = acceptRecordPolicy;
        this.filterExpression = expression;
        this.expressionManager = expressionManager;
        if (!StringUtils.isEmpty(expression) && !expressionManager.isValid(expression)) {
            throw new IllegalArgumentException(String.format("Filter expression '%s' is not a valid expression", expression));
        }
    }

    public boolean acceptRecord(CoreEvent event, Record record) {
        if (!this.acceptRecordPolicy.accept(record)) {
            return false;
        }
        return this.filterExpression == null || this.expressionManager.evaluateBoolean(this.filterExpression, event, null);
    }
}

