/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.internal.streaming.object.iterator.ObjectStoreProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerAwareObjectStoreProducer<T>
implements Producer<T> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreProducer.class);
    private ObjectStore<byte[]> objectStore;
    private ObjectSerializer serializer;
    private Iterator<String> keys;
    private int size;

    public SerializerAwareObjectStoreProducer(ObjectStore<byte[]> objectStore, ObjectSerializer serializer) {
        if (objectStore == null) {
            throw new IllegalArgumentException("Cannot construct a producer with a null object store");
        }
        this.objectStore = objectStore;
        this.serializer = serializer;
        try {
            ArrayList<String> allKeys = new ArrayList<String>(objectStore.allKeys());
            this.keys = allKeys.iterator();
            this.size = allKeys.size();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("Could not construct producer because exception was found retrieving keys", e);
        }
    }

    @Override
    public T produce() {
        if (this.objectStore == null || !this.keys.hasNext()) {
            return null;
        }
        String key = this.keys.next();
        try {
            return this.serializer.getInternalProtocol().deserialize(this.objectStore.retrieve(key));
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("key %s no longer available in the object store. This is likely due to a concurrency issue. Will continue with next key if available", key));
            }
            return this.produce();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void close() throws IOException {
        this.objectStore = null;
        this.keys = null;
    }
}

