/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.google.common.base.Preconditions;
import com.hazelcast.core.IExecutorService;
import com.mulesoft.mule.runtime.module.cluster.internal.CurrentTimeInMillisCallable;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.mule.runtime.api.time.TimeSupplier;

public class HazelcastClientModeTimeSupplier
implements TimeSupplier {
    private final IExecutorService executorService;

    public HazelcastClientModeTimeSupplier(HazelcastClusterManager hazelcastManager) {
        Preconditions.checkNotNull((Object)hazelcastManager, (Object)"Hazelcast manager cannot be null");
        this.executorService = new HazelcastExecutorService(hazelcastManager);
    }

    @Override
    public Long get() {
        Future remoteCallFuture = this.executorService.submit(this.getCurrentTimeInMillisCallable());
        try {
            return (Long)remoteCallFuture.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public long getAsLong() {
        Future remoteCallFuture = this.executorService.submit(this.getCurrentTimeInMillisCallable());
        try {
            return (Long)remoteCallFuture.get();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private Callable getCurrentTimeInMillisCallable() {
        return new CurrentTimeInMillisCallable();
    }
}

