/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.spi.properties.GroupProperty;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigLogger {
    private static final Logger logger = LoggerFactory.getLogger(ClusterConfigLogger.class);

    public void log(Config config) {
        logger.info("Mule cluster setup properties >>>");
        this.logClusterIds(config);
        this.logDiscoverySPIConfig(config);
        this.logReadBackupDataConfiguration(config);
        this.logClusterServersDiscoveryMode(config);
        this.logClusterPortUsage(config);
        this.logNetworkInterfaceUsage(config);
        this.logDataBackupCount(config);
        this.logManagementCenterConfiguration(config);
        this.logQuorumConfiguration(config);
        this.logJMXConfig(config);
        logger.info("Mule cluster setup properties <<<");
    }

    private void logDiscoverySPIConfig(Config config) {
        String discoverySPIEnabled = config.getProperty(GroupProperty.DISCOVERY_SPI_ENABLED.getName());
        if (Boolean.valueOf(discoverySPIEnabled).booleanValue()) {
            logger.info("Discovery SPI is enabled");
            for (DiscoveryStrategyConfig dsConfig : config.getNetworkConfig().getJoin().getDiscoveryConfig().getDiscoveryStrategyConfigs()) {
                for (String key : dsConfig.getProperties().keySet()) {
                    logger.info("Discovery SPI Property " + key + " : " + dsConfig.getProperties().get(key));
                }
            }
        } else {
            logger.info("Discovery SPI is not enabled.");
        }
    }

    private void logClusterPortUsage(Config config) {
        logger.info(String.format("Using port %s for inbound connections", config.getNetworkConfig().getPort()));
        logger.info(String.format("Inbound request port autoincrement is %s", config.getNetworkConfig().isPortAutoIncrement() ? "enabled" : "disabled"));
        if (config.getNetworkConfig().getOutboundPorts() == null) {
            logger.info(String.format("Using random port for outobund connections", new Object[0]));
        } else {
            logger.info(String.format("Using port/s %s for outbound connections", Arrays.toString(config.getNetworkConfig().getOutboundPorts().toArray())));
        }
    }

    private void logClusterIds(Config config) {
        logger.info("Cluster id: " + config.getGroupConfig().getName());
        logger.info("Cluster node id: " + config.getInstanceName());
    }

    private void logManagementCenterConfiguration(Config config) {
        ManagementCenterConfig managementCenterConfig = config.getManagementCenterConfig();
        if (managementCenterConfig.isEnabled()) {
            logger.info("Management center connection enabled");
            logger.info("Management center provided URL: " + (managementCenterConfig.getUrl() == null ? "URL NOT SET" : managementCenterConfig.getUrl()));
        }
    }

    private void logDataBackupCount(Config config) {
        logger.info("Message backup count: " + config.getMapConfig("default").getBackupCount());
    }

    private void logNetworkInterfaceUsage(Config config) {
        InterfacesConfig interfaces = config.getNetworkConfig().getInterfaces();
        if (interfaces.isEnabled()) {
            logger.info("Network interfaces restriction enabled");
            logger.info("Network interfaces to use: ");
            for (String interfase : interfaces.getInterfaces()) {
                logger.info(" - " + interfase);
            }
        } else {
            logger.info("No network interface restriction. Using all available interfaces");
        }
    }

    private void logClusterServersDiscoveryMode(Config config) {
        if (config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            logger.info("Multicast to discover cluster nodes enabled");
        } else {
            logger.info("Multicast to discover cluster nodes disabled");
        }
        TcpIpConfig tcpIpConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
        if (tcpIpConfig.isEnabled()) {
            logger.info("TCP/IP to discover cluster nodes enabled");
            logger.info("TCP/IP time to connect " + tcpIpConfig.getConnectionTimeoutSeconds() + " seconds");
            List members = tcpIpConfig.getMembers();
            if (members.isEmpty()) {
                logger.info("No cluster member ip was specified for TCP/IP discovery");
            } else {
                logger.info("TCP/IP discovery members:");
                for (String member : members) {
                    logger.info(" - " + member);
                }
            }
        } else {
            logger.info("TCP/IP to discover cluster nodes disabled");
        }
    }

    private void logReadBackupDataConfiguration(Config config) {
        logger.info("Reading backup data: " + config.getMapConfig("default").isReadBackupData());
    }

    private void logQuorumConfiguration(Config config) {
        QuorumConfig quorumConfig = config.getQuorumConfig("default-quorum");
        if (quorumConfig != null) {
            logger.info("Quorum enabled: " + quorumConfig.isEnabled());
            logger.info("Quorum size: " + quorumConfig.getSize());
        }
    }

    private void logJMXConfig(Config config) {
        String value = config.getProperty("hazelcast.jmx");
        if (value != null) {
            logger.info("JMX enabled: " + value);
        }
    }
}

