/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.config.persistence;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mulesoft.mule.runtime.module.cluster.internal.config.persistence.JdbcDataSourceFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.config.persistence.JdbcMapStoreDataSourceConfiguration;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.math.NumberUtils;

public class C3p0PooledDataSourceFactory
implements JdbcDataSourceFactory {
    public static String JDBC_CLUSTER_STORE_C3P0_INITIAL_POOL_SIZE = "mule.cluster.c3p0.jdbcstoreinitialpoolsize";
    public static String JDBC_CLUSTER_STORE_C3P0_MAX_IDLE_TIME = "mule.cluster.c3p0.jdbcstoremaxidletime";
    public static String JDBC_CLUSTER_STORE_C3P0_MAX_POOL_SIZE = "mule.cluster.c3p0.jdbcstoremaxpoolsize";
    public static String JDBC_CLUSTER_STORE_C3P0_MIN_POOL_SIZE = "mule.cluster.c3p0.jdbcstoreminpoolsize";
    public static String JDBC_CLUSTER_STORE_C3P0_DATASOURCE_NAME = "mule.cluster.c3p0.jdbcstorename";
    public String DEFAULT_DATASOURCE_NAME = "DEFAULT_DATASOURCE_NAME";

    @Override
    public DataSource createDataSource(JdbcMapStoreDataSourceConfiguration dataSourceConfiguration) throws PropertyVetoException {
        Properties clusterProperties = dataSourceConfiguration.getClusterProperties();
        String dataSourceNameProperty = clusterProperties.getProperty(JDBC_CLUSTER_STORE_C3P0_DATASOURCE_NAME);
        Integer initialPoolSizeProperty = NumberUtils.createInteger((String)clusterProperties.getProperty(JDBC_CLUSTER_STORE_C3P0_INITIAL_POOL_SIZE));
        Integer maxIdleTimeProperty = NumberUtils.createInteger((String)clusterProperties.getProperty(JDBC_CLUSTER_STORE_C3P0_MAX_IDLE_TIME));
        Integer maxPoolSizeProperty = NumberUtils.createInteger((String)clusterProperties.getProperty(JDBC_CLUSTER_STORE_C3P0_MAX_POOL_SIZE));
        Integer minPoolSizeProperty = NumberUtils.createInteger((String)clusterProperties.getProperty(JDBC_CLUSTER_STORE_C3P0_MIN_POOL_SIZE));
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource(this.getDataSourceName(dataSourceNameProperty));
        if (dataSourceConfiguration.getDriverClassName() != null) {
            comboPooledDataSource.setDriverClass(dataSourceConfiguration.getDriverClassName());
        }
        if (initialPoolSizeProperty != null) {
            comboPooledDataSource.setInitialPoolSize(initialPoolSizeProperty.intValue());
        }
        if (dataSourceConfiguration.getJdbcUrl() != null) {
            comboPooledDataSource.setJdbcUrl(dataSourceConfiguration.getJdbcUrl());
        }
        if (maxIdleTimeProperty != null) {
            comboPooledDataSource.setMaxIdleTime(maxIdleTimeProperty.intValue());
        }
        if (maxPoolSizeProperty != null) {
            comboPooledDataSource.setMaxPoolSize(maxPoolSizeProperty.intValue());
        }
        if (minPoolSizeProperty != null) {
            comboPooledDataSource.setMinPoolSize(minPoolSizeProperty.intValue());
        }
        if (dataSourceConfiguration.getPassword() != null) {
            comboPooledDataSource.setPassword(dataSourceConfiguration.getPassword());
        }
        if (dataSourceConfiguration.getUsername() != null) {
            comboPooledDataSource.setUser(dataSourceConfiguration.getUsername());
        }
        return comboPooledDataSource;
    }

    private String getDataSourceName(String dataSourceName) {
        return dataSourceName == null ? this.DEFAULT_DATASOURCE_NAME : dataSourceName;
    }
}

