/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.serializer.ArtifactClassLoaderObjectInputStream;
import org.mule.runtime.module.artifact.api.serializer.ArtifactClassLoaderObjectOutputStream;

public class JdbcMapStoreSerializationProtocol
implements SerializationProtocol {
    private final ClassLoaderRepository classLoaderRepository;

    public JdbcMapStoreSerializationProtocol(ClassLoaderRepository classLoaderRepository) {
        this.classLoaderRepository = classLoaderRepository;
    }

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ArtifactClassLoaderObjectOutputStream out = new ArtifactClassLoaderObjectOutputStream(this.classLoaderRepository, outputStream);){
                out.writeObject(object);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Cannot serialize object", (Throwable)ex);
        }
        return outputStream.toByteArray();
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        try {
            try {
                byte[] bytes = this.serialize(object);
                out.write(bytes);
                out.flush();
            }
            catch (IOException e) {
                throw new SerializationException("Could not write to output stream", (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) throws SerializationException {
        Preconditions.checkArgument(bytes != null, "The byte[] must not be null");
        return this.deserialize(bytes, null);
    }

    @Override
    public <T> T deserialize(InputStream inputStream) throws SerializationException {
        return this.deserialize(inputStream, null);
    }

    @Override
    public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
        return this.deserialize(new ByteArrayInputStream(bytes), classLoader);
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        Preconditions.checkArgument(inputStream != null, "Cannot deserialize a null stream");
        try {
            Object object;
            ArtifactClassLoaderObjectInputStream in;
            Throwable throwable;
            block15: {
                throwable = null;
                Object var4_6 = null;
                in = new ArtifactClassLoaderObjectInputStream(this.classLoaderRepository, inputStream);
                object = in.readObject();
                if (in == null) break block15;
                in.close();
            }
            return (T)object;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        throw new SerializationException("Cannot deserialize object", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

