/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.license.internal;

import com.mulesoft.mule.runtime.module.license.internal.ProviderLicense;
import com.mulesoft.mule.runtime.module.license.internal.SecurityUtils;
import com.mulesoft.mule.runtime.module.license.internal.ZippedBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.module.license.api.exception.InvalidLicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerLicense {
    public static final String FEATURE_KEY = "feature.name";
    public static final String VERSIONS_KEY = "valid.versions";
    public static final String CREATION_DATE_KEY = "creation.date";
    public static final String EXPIRATION_DATE_KEY = "expiration.date";
    private static final Logger logger = LoggerFactory.getLogger(CustomerLicense.class);
    private static final Pattern versionRangePattern = Pattern.compile("(\\[|\\()([^,]*),(.*)(\\]|\\))");
    private final String licFileName;
    private final String infoFile;
    private final String signatureFile;
    private final Properties data;

    public CustomerLicense(String licName, ClassLoader artifactClassLoader, ProviderLicense providerLicense) throws InvalidKeyException {
        if (org.mule.runtime.core.api.util.StringUtils.isBlank(licName)) {
            throw new IllegalArgumentException("Provider and ID and license name cannot be blank");
        }
        String licenseNameWithoutExtension = licName.replace(".lic", "");
        this.licFileName = licName;
        this.signatureFile = licenseNameWithoutExtension.concat(".sig");
        this.infoFile = licenseNameWithoutExtension.concat(".info");
        try {
            ZippedBundle licBundle = this.loadLicBundle(artifactClassLoader, this.licFileName);
            if (!this.signatureIsValid(licBundle, providerLicense.getKey())) {
                throw new InvalidLicenseException("[" + this.signatureFile + "] signature is not valid for license " + this.infoFile);
            }
            this.data = this.loadMetaData(licBundle);
        }
        catch (InvalidLicenseException e) {
            throw new InvalidLicenseException(String.format("Required License %s was not found or is not a valid license. Please contact your license provider %s at %s. %s", this.licFileName, providerLicense.getProviderName(), providerLicense.getEmail(), providerLicense.getContactMessage()), e);
        }
    }

    public boolean isValid(String pluginVersion, String requiredEntitlement) {
        return this.hasValidEntitlement(requiredEntitlement) && this.hasValidDate() && this.hasValidVersion(pluginVersion);
    }

    public boolean hasValidVersion(String version) {
        Matcher rangeMatcher;
        MuleVersion current = new MuleVersion(version);
        String validVersions = this.data.getProperty(VERSIONS_KEY);
        if (!org.mule.runtime.core.api.util.StringUtils.isBlank(validVersions) && (rangeMatcher = versionRangePattern.matcher(validVersions)).matches()) {
            boolean minIncluded = StringUtils.equals((CharSequence)rangeMatcher.group(1), (CharSequence)"[");
            String minVersion = rangeMatcher.group(2);
            String maxVersion = rangeMatcher.group(3);
            boolean maxIncluded = StringUtils.equals((CharSequence)rangeMatcher.group(4), (CharSequence)"]");
            if (!((org.mule.runtime.core.api.util.StringUtils.isBlank(minVersion) || new MuleVersion(minVersion).priorTo(current) || minIncluded && new MuleVersion(minVersion).sameAs(current)) && (org.mule.runtime.core.api.util.StringUtils.isBlank(maxVersion) || new MuleVersion(maxVersion).newerThan(current) || maxIncluded && new MuleVersion(minVersion).sameAs(current)))) {
                return false;
            }
        }
        return true;
    }

    public boolean hasValidEntitlement(String requiredEntitlement) {
        return StringUtils.equals((CharSequence)this.data.getProperty(FEATURE_KEY), (CharSequence)requiredEntitlement);
    }

    public boolean hasValidDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        Date today = new Date();
        String creation = this.data.getProperty(CREATION_DATE_KEY);
        String expiration = this.data.getProperty(EXPIRATION_DATE_KEY);
        if (org.mule.runtime.core.api.util.StringUtils.isBlank(creation)) {
            throw new InvalidLicenseException("Invalid data found inside license info. Missing creation Date");
        }
        try {
            return !today.before(dateFormat.parse(creation)) && (org.mule.runtime.core.api.util.StringUtils.isBlank(expiration) || !today.after(dateFormat.parse(expiration)));
        }
        catch (ParseException e) {
            throw new InvalidLicenseException("Invalid date found inside license info. Failed to parse creation or expiration date", e);
        }
    }

    private boolean signatureIsValid(ZippedBundle lic, PublicKey vendorKey) throws InvalidKeyException {
        Optional<byte[]> signature = lic.get(this.signatureFile);
        if (!signature.isPresent()) {
            logger.error("No signature named " + this.signatureFile + " found in bundle " + this.licFileName);
            throw new InvalidLicenseException("Failed to verify signature " + this.signatureFile + ". No signature named " + this.signatureFile + " found in bundle " + this.licFileName);
        }
        Optional<byte[]> metadata = lic.get(this.infoFile);
        if (!metadata.isPresent()) {
            logger.error("No info file named " + this.infoFile + " found in bundle " + this.licFileName);
            throw new InvalidLicenseException("Failed to verify license metadata. No info file named " + this.infoFile + " found in bundle " + this.licFileName);
        }
        try {
            return SecurityUtils.verify(signature.get(), metadata.get(), vendorKey);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new InvalidLicenseException("An error occurred wile trying to verify signature [" + this.signatureFile + "] for file " + this.infoFile);
        }
    }

    private Properties loadMetaData(ZippedBundle licBundle) throws InvalidKeyException {
        Optional<byte[]> info = licBundle.get(this.infoFile);
        if (!info.isPresent()) {
            logger.error("No metadata file named " + this.infoFile + " found in bundle " + this.infoFile);
            throw new InvalidLicenseException("Failed to verify license metadata. No info file named " + this.infoFile + " found in bundle " + this.licFileName);
        }
        try {
            Properties metadata = new Properties();
            metadata.load(new ByteArrayInputStream(info.get()));
            return metadata;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new InvalidLicenseException("Failed to load license properties from " + this.infoFile + " found in license " + licBundle);
        }
    }

    private ZippedBundle loadLicBundle(ClassLoader artifactClassLoader, String licFile) {
        InputStream bundleIS = artifactClassLoader.getResourceAsStream(licFile);
        if (bundleIS == null) {
            logger.error("License file with name [" + licFile + "] not found as resource");
            throw new InvalidLicenseException("License with name [" + licFile + "] not found as resource. License was not provided or its name is not the expected");
        }
        return new ZippedBundle(bundleIS);
    }

    public String getLicFileName() {
        return this.licFileName;
    }

    public String getExpirationDate() {
        return this.data.getProperty(EXPIRATION_DATE_KEY);
    }
}

