/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression;

import com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression.KryoCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

final class GzipKryoCompressor
implements KryoCompressor {
    GzipKryoCompressor() {
    }

    @Override
    public OutputStream compress(OutputStream outputStream) {
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create GZip output compression delegate"), (Throwable)e);
        }
    }

    @Override
    public InputStream decompress(InputStream inputStream) {
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create GZip input compression delegate"), (Throwable)e);
        }
    }
}

