/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.protocol;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.KryoInstanceFactory;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression.KryoCompressionMode;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.compression.KryoCompressor;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.mapper.DefaultSerializationMapper;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.mapper.SerializationMapper;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.serialization.AbstractSerializationProtocol;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public final class KryoSerializationProtocol
extends AbstractSerializationProtocol
implements Initialisable {
    @Inject
    private Registry registry;
    @Inject
    private ClassLoaderRepository classLoaderRepository;
    private final KryoInstanceFactory kryoInstanceFactory;
    private LoadingCache<Thread, Kryo> kryoInstances;
    private final KryoCompressor compressor;
    private final SerializationMapper serializationMapper;
    private static ThreadLocal<Boolean> kryoInstanceUsedInThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public KryoSerializationProtocol(KryoInstanceFactory kryoInstanceFactory, KryoCompressionMode compressionMode) {
        this(kryoInstanceFactory, compressionMode, new DefaultSerializationMapper());
    }

    public KryoSerializationProtocol(KryoInstanceFactory kryoInstanceFactory, KryoCompressionMode compressionMode, SerializationMapper serializationMapper) {
        Preconditions.checkArgument(kryoInstanceFactory != null, "Cannot have a null kryoInstanceFactory");
        Preconditions.checkArgument(compressionMode != null, "Cannot have a null compressionMode");
        Preconditions.checkArgument(serializationMapper != null, "Cannot have a null serializationHelper");
        this.compressor = compressionMode.getCompressor();
        this.kryoInstanceFactory = kryoInstanceFactory;
        this.serializationMapper = serializationMapper;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.kryoInstances = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Thread, Kryo>(){

            public Kryo load(Thread key) throws Exception {
                return KryoSerializationProtocol.this.kryoInstanceFactory.getInstance(KryoSerializationProtocol.this.muleContext, Optional.of(KryoSerializationProtocol.this.classLoaderRepository));
            }
        });
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        this.doSerialize(object, out);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.doSerialize(object, out);
        return out.toByteArray();
    }

    private void doSerialize(Object object, OutputStream out) throws SerializationException {
        Kryo kryo = this.getKryo();
        boolean kryoInstanceUsedInThreadOldValue = kryoInstanceUsedInThread.get();
        try {
            kryoInstanceUsedInThread.set(true);
            Object mapped = this.serializationMapper.mapBeforeSerialization(object);
            this.onOutput(out, output -> kryo.writeClassAndObject(output, mapped));
        }
        finally {
            kryoInstanceUsedInThread.set(kryoInstanceUsedInThreadOldValue);
        }
    }

    private void onOutput(OutputStream outputStream, Consumer<Output> lambda) {
        try (Output output = new Output(this.compressor.compress(outputStream));){
            lambda.accept(output);
        }
    }

    @Override
    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Kryo kryo = this.getKryo();
        kryo.setClassLoader(classLoader);
        Object deserialized = kryo.readClassAndObject(new Input(this.compressor.decompress(inputStream)));
        return (T)this.serializationMapper.mapAfterDeserialization(deserialized);
    }

    private Kryo getKryo() throws SerializationException {
        if (kryoInstanceUsedInThread.get().booleanValue()) {
            try {
                return this.kryoInstanceFactory.getInstance(this.muleContext, Optional.of(this.classLoaderRepository));
            }
            catch (Exception e) {
                throw new SerializationException("Unable to create a kryo instance.", (Throwable)e);
            }
        }
        return (Kryo)this.kryoInstances.getUnchecked((Object)Thread.currentThread());
    }
}

