/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin;

import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManager;
import com.mulesoft.mule.runtime.plugin.classloader.ServerPluginClassLoaderFactory;
import com.mulesoft.mule.runtime.plugin.discoverer.FileSystemPluginDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.MulePluginConfigurerFactory;
import com.mulesoft.mule.runtime.plugin.factory.MulePluginFactory;
import com.mulesoft.mule.runtime.plugin.factory.MulePluginPropertyDiscovererFactory;
import com.mulesoft.mule.runtime.plugin.factory.PluginFactory;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import com.mulesoft.mule.runtime.plugin.management.internal.MuleInstanceManagerAwareProcessor;
import com.mulesoft.mule.runtime.plugin.management.internal.TanukiWrapperMuleInstanceManager;
import com.mulesoft.mule.runtime.plugin.manager.MulePluginManagerFactory;
import com.mulesoft.mule.runtime.plugin.manager.PluginManager;
import com.mulesoft.mule.runtime.plugin.processor.CompositePluginProcessor;
import com.mulesoft.mule.runtime.plugin.processor.PluginProcessor;
import com.mulesoft.mule.runtime.plugin.processor.coreextension.CoreExtensionsAwareProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.DeploymentListenerProviderProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.DeploymentServiceAwareProcessor;
import com.mulesoft.mule.runtime.plugin.processor.deployment.RepositoryServiceAwareProcessor;
import com.mulesoft.mule.runtime.plugin.processor.tooling.ToolingServiceAwareProcessor;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.api.classloader.TrackingArtifactClassLoaderFactory;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.launcher.coreextension.ContainerInjectorBuilder;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.tooling.api.ToolingService;

public class ServerPluginCoreExtension
implements MuleCoreExtension {
    public static final String PLUGINS_DIR_PROPERTY = "mule.plugins.dir";
    public static final String DEFAULT_SERVER_PLUGINS_DIR = "server-plugins";
    private PluginManager pluginManager;
    private MuleInstanceManager muleInstanceManager = new TanukiWrapperMuleInstanceManager();
    private DeploymentService deploymentService;
    private List<MuleCoreExtension> coreExtensions;
    private ArtifactClassLoader containerClassLoader;
    private RepositoryService repositoryService;
    private ToolingService toolingService;
    private ArtifactClassLoaderManager artifactClassLoaderManager;
    private EventContextService eventContextService;
    private ServiceRepository serviceRepository;
    private Injector containerInjector;

    @Override
    public void dispose() {
        if (this.pluginManager != null) {
            this.pluginManager.dispose();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        this.containerInjector = this.createContainerInjector();
        this.pluginManager = this.createDefaultPluginManager();
        this.pluginManager.initialise();
    }

    private PluginProcessor createDefaultPluginProcessor() {
        CompositePluginProcessor compositePluginProcessor = new CompositePluginProcessor();
        if (this.muleInstanceManager != null) {
            compositePluginProcessor.addProcessor(new MuleInstanceManagerAwareProcessor(this.muleInstanceManager));
        }
        if (this.deploymentService != null) {
            compositePluginProcessor.addProcessor(new DeploymentListenerProviderProcessor(this.deploymentService));
            compositePluginProcessor.addProcessor(new DeploymentServiceAwareProcessor(this.deploymentService));
        }
        if (this.repositoryService != null) {
            compositePluginProcessor.addProcessor(new RepositoryServiceAwareProcessor(this.repositoryService));
        }
        if (this.toolingService != null) {
            compositePluginProcessor.addProcessor(new ToolingServiceAwareProcessor(this.toolingService));
        }
        compositePluginProcessor.addProcessor(new CoreExtensionsAwareProcessor(this.coreExtensions));
        return compositePluginProcessor;
    }

    private Injector createContainerInjector() {
        return ((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)((PluginContainerInjectorBuilder)new PluginContainerInjectorBuilder().withDeploymentService(this.deploymentService)).withRepositoryService(this.repositoryService)).withServiceRepository(this.serviceRepository)).withCoreExtensions(this.coreExtensions)).withArtifactClassLoaderManager(this.artifactClassLoaderManager)).withEventContextService(this.eventContextService)).withToolingService(this.toolingService)).withMuleInstanceManager(this.muleInstanceManager).build();
    }

    private PluginManager createDefaultPluginManager() {
        File pluginsFolder = this.getPluginsFolder();
        if (!pluginsFolder.exists()) {
            pluginsFolder.mkdir();
        }
        FileSystemPluginDiscoverer pluginDiscoverer = new FileSystemPluginDiscoverer(pluginsFolder);
        PluginFactory pluginFactory = this.createDefaultPluginFactory();
        MulePluginManagerFactory pluginManagerFactory = new MulePluginManagerFactory(pluginDiscoverer, pluginFactory);
        PluginProcessor pluginProcessor = this.createDefaultPluginProcessor();
        pluginManagerFactory.setPluginProcessor(pluginProcessor);
        return pluginManagerFactory.create();
    }

    private File getPluginsFolder() {
        String property = System.getProperty(PLUGINS_DIR_PROPERTY);
        if (StringUtils.isEmpty(property)) {
            return new File(MuleContainerBootstrapUtils.getMuleBase(), DEFAULT_SERVER_PLUGINS_DIR);
        }
        return new File(property);
    }

    private PluginFactory createDefaultPluginFactory() {
        if (this.containerClassLoader == null) {
            throw new IllegalStateException("ContainerClassLoader was not properly initialized");
        }
        return new MulePluginFactory(new TrackingArtifactClassLoaderFactory<ServerPluginDescriptor>(this.artifactClassLoaderManager, new ServerPluginClassLoaderFactory()), new MulePluginPropertyDiscovererFactory(), new MulePluginConfigurerFactory(), this.containerClassLoader, this.containerInjector);
    }

    @Override
    public String getName() {
        return "Mule Plugin Core Extension";
    }

    @Override
    public void start() throws MuleException {
        this.pluginManager.start();
    }

    @Override
    public void stop() throws MuleException {
        if (this.pluginManager != null) {
            this.pluginManager.stop();
        }
    }

    @Inject
    public void setMuleInstanceManager(MuleInstanceManager muleInstanceManager) {
        this.muleInstanceManager = muleInstanceManager;
    }

    @Inject
    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Inject
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Inject
    public void setCoreExtensions(List<MuleCoreExtension> coreExtensions) {
        this.coreExtensions = coreExtensions;
    }

    @Override
    @Inject
    public void setContainerClassLoader(ArtifactClassLoader containerClassLoader) {
        this.containerClassLoader = containerClassLoader;
    }

    @Inject
    public void setEventContextService(EventContextService eventContextService) {
        this.eventContextService = eventContextService;
    }

    @Inject
    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    @Inject
    public void setServiceRepository(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    @Inject
    public void setArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.artifactClassLoaderManager = artifactClassLoaderManager;
    }

    private class PluginContainerInjectorBuilder
    extends ContainerInjectorBuilder<PluginContainerInjectorBuilder> {
        private PluginContainerInjectorBuilder() {
        }

        @Override
        protected PluginContainerInjectorBuilder getThis() {
            return this;
        }

        public PluginContainerInjectorBuilder withMuleInstanceManager(MuleInstanceManager muleInstanceManager) {
            this.registerObject(MuleInstanceManager.class.getName(), muleInstanceManager);
            return this.getThis();
        }
    }
}

