/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.factory;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.plugin.InvalidPropertyValueException;
import com.mulesoft.mule.runtime.plugin.factory.PluginConfigurer;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.NotWritablePropertyException;

public class MulePluginConfigurer
implements PluginConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MulePluginConfigurer.class);
    private final MulePlugin mulePlugin;

    public MulePluginConfigurer(MulePlugin mulePlugin) {
        this.mulePlugin = mulePlugin;
    }

    @Override
    public void configure(Map<String, String> properties) {
        ClassUtils.withContextClassLoader(this.mulePlugin.getClass().getClassLoader(), () -> {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)this.mulePlugin);
            for (String name : properties.keySet()) {
                try {
                    beanWrapper.setPropertyValue(name, properties.get(name));
                }
                catch (NotWritablePropertyException notWritablePropertyException) {
                    logger.warn("Ignoring property '{}' for plugin class [{}] due to it is not writable", (Object)name, (Object)this.mulePlugin.getClass().getName());
                }
                catch (Exception e) {
                    throw new InvalidPropertyValueException(name, e);
                }
            }
            return null;
        }, InvalidPropertyValueException.class, e -> {
            throw new MuleRuntimeException(e);
        });
    }
}

