/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.manager;

import com.mulesoft.mule.runtime.plugin.ManagedMulePlugin;
import com.mulesoft.mule.runtime.plugin.manager.PluginAlreadyRegisteredException;
import com.mulesoft.mule.runtime.plugin.manager.PluginLifecycleException;
import com.mulesoft.mule.runtime.plugin.manager.PluginManager;
import com.mulesoft.mule.runtime.plugin.manager.PluginNoRegisteredException;
import com.mulesoft.mule.runtime.plugin.processor.PluginProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulePluginManager
implements PluginManager {
    protected static final Logger logger = LoggerFactory.getLogger(MulePluginManager.class);
    private Map<String, ManagedMulePlugin> plugins = new HashMap<String, ManagedMulePlugin>();
    private PluginProcessor pluginProcessor;

    @Override
    public void registerPlugin(ManagedMulePlugin plugin) throws PluginAlreadyRegisteredException {
        if (logger.isInfoEnabled()) {
            logger.info("Registering plugin: " + plugin.getName());
        }
        if (this.plugins.containsKey(plugin.getName())) {
            throw new PluginAlreadyRegisteredException(plugin.getName());
        }
        this.plugins.put(plugin.getName(), plugin);
    }

    @Override
    public void unregisterPlugin(String name) {
        ManagedMulePlugin managedPlugin;
        if (logger.isInfoEnabled()) {
            logger.info("Unregistering plugin: " + name);
        }
        if ((managedPlugin = this.plugins.get(name)) == null) {
            throw new PluginNoRegisteredException(name);
        }
        this.plugins.remove(name);
    }

    @Override
    public Collection<ManagedMulePlugin> registeredPlugins() {
        return new HashMap<String, ManagedMulePlugin>(this.plugins).values();
    }

    @Override
    public ManagedMulePlugin findRegisteredPlugin(String name) {
        return this.plugins.get(name);
    }

    @Override
    public void disablePlugin(String name) {
        ManagedMulePlugin managedPlugin = this.plugins.get(name);
        if (managedPlugin == null) {
            throw new PluginNoRegisteredException(name);
        }
        if (!managedPlugin.isEnabled()) {
            throw new PluginLifecycleException(String.format("Plugin '%s' is already disabled", name));
        }
        this.stopPlugin(managedPlugin);
        managedPlugin.setEnabled(false);
    }

    @Override
    public void enablePlugin(String name) {
        ManagedMulePlugin managedPlugin = this.plugins.get(name);
        if (managedPlugin == null) {
            throw new PluginNoRegisteredException(name);
        }
        if (managedPlugin.isEnabled()) {
            throw new PluginLifecycleException(String.format("Plugin '%s' is already enabled", name));
        }
        if (managedPlugin.getPlugin().isDisabledOnEnvironment()) {
            throw new PluginLifecycleException(String.format("Plugin '%s' cannot be enabled on current environment", name));
        }
        this.startPlugin(managedPlugin);
        managedPlugin.setEnabled(true);
    }

    @Override
    public void dispose() {
        for (ManagedMulePlugin plugin : this.plugins.values()) {
            try {
                if (this.pluginProcessor != null) {
                    this.pluginProcessor.disposePlugin(plugin);
                }
                plugin.dispose();
            }
            catch (Exception e) {
                logger.warn(String.format("Error disposing plugin '%s'", plugin.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        for (ManagedMulePlugin plugin : this.registeredPlugins()) {
            try {
                if (this.pluginProcessor != null) {
                    this.pluginProcessor.initialisePlugin(plugin);
                }
                plugin.initialise();
            }
            catch (Exception e) {
                logger.warn(String.format("Cannot initialise plugin '%s'. Plugin will be unregistered", plugin.getName()), (Throwable)e);
                this.unregisterPlugin(plugin.getName());
            }
        }
    }

    @Override
    public void start() throws MuleException {
        for (ManagedMulePlugin managedPlugin : this.registeredPlugins()) {
            if (!managedPlugin.isEnabled() || managedPlugin.getPlugin().isDisabledOnEnvironment()) continue;
            this.startPlugin(managedPlugin);
        }
    }

    private void startPlugin(ManagedMulePlugin plugin) {
        if (logger.isInfoEnabled()) {
            logger.info("Starting plugin: " + plugin.getName());
        }
        try {
            if (this.pluginProcessor != null) {
                this.pluginProcessor.startPlugin(plugin);
            }
            plugin.start();
        }
        catch (Exception e) {
            logger.warn(String.format("Cannot start plugin '%s'. Plugin will be unregistered", plugin.getName()), (Throwable)e);
            this.unregisterPlugin(plugin.getName());
        }
    }

    @Override
    public void stop() throws MuleException {
        for (ManagedMulePlugin plugin : this.plugins.values()) {
            if (!plugin.isEnabled()) continue;
            this.stopPlugin(plugin);
        }
    }

    private void stopPlugin(ManagedMulePlugin plugin) {
        if (logger.isInfoEnabled()) {
            logger.info("Stopping plugin: " + plugin.getName());
        }
        try {
            if (this.pluginProcessor != null) {
                this.pluginProcessor.stopPlugin(plugin);
            }
            plugin.stop();
        }
        catch (Exception e) {
            logger.warn(String.format("Error stopping plugin '%s'", plugin.getName()), (Throwable)e);
        }
    }

    public void setPluginProcessor(PluginProcessor pluginProcessor) {
        this.pluginProcessor = pluginProcessor;
    }
}

