/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import java.net.InetSocketAddress;
import java.net.URI;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.ServerConnection;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.service.http.impl.service.server.grizzly.DefaultServerConnection;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpMessage;
import org.mule.service.http.impl.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyInboundWebSocketRequest
extends GrizzlyHttpMessage
implements WebSocketRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyInboundWebSocketRequest.class);
    private final HttpEntity entity = new EmptyHttpEntity();
    private WebSocketProtocol scheme;
    private ServerConnection serverConnection;
    private ClientConnection clientConnection;
    private MediaType contentType;
    private String httpVersion;

    public GrizzlyInboundWebSocketRequest(HttpRequestPacket requestPacket) {
        super(requestPacket, null, (InetSocketAddress)requestPacket.getConnection().getLocalAddress());
        this.httpVersion = requestPacket.getProtocol().toString();
    }

    @Override
    public WebSocketProtocol getScheme() {
        if (this.scheme == null) {
            this.scheme = SSLUtils.getSSLEngine((Connection)this.requestPacket.getConnection()) != null ? WebSocketProtocol.WSS : WebSocketProtocol.WS;
        }
        return this.scheme;
    }

    @Override
    public String getHttpVersion() {
        if (this.httpVersion == null) {
            this.httpVersion = this.requestPacket.getProtocol().toString();
        }
        return this.httpVersion;
    }

    @Override
    public URI getRequestUri() {
        return this.getUri();
    }

    @Override
    public MediaType getContentType() {
        if (this.contentType == null) {
            try {
                String contentType = this.requestPacket.getContentType();
                this.contentType = contentType != null ? MediaType.parse(contentType) : MediaType.ANY;
            }
            catch (Exception e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Received inbound WebSocket request at path {} with invalid Content-Type '{}'. Will default to '{}'", new Object[]{this.getPath(), this.contentType, MediaType.ANY.toRfcString()});
                }
                this.contentType = MediaType.ANY;
            }
        }
        return this.contentType;
    }

    @Override
    public ServerConnection getServerConnection() {
        if (this.serverConnection == null) {
            this.serverConnection = new DefaultServerConnection((InetSocketAddress)this.requestPacket.getConnection().getLocalAddress());
        }
        return this.serverConnection;
    }

    @Override
    public ClientConnection getClientConnection() {
        if (this.clientConnection == null) {
            this.clientConnection = HttpUtils.getClientConnection(this.requestPacket.getConnection());
        }
        return this.clientConnection;
    }

    @Override
    protected String getBaseProtocol() {
        return this.getScheme().getScheme();
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }
}

