/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.reconnect.OutboundWebSocketReconnectionHandler;
import com.mulesoft.service.http.impl.service.ws.DataFrameEmitter;
import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import com.mulesoft.service.http.impl.service.ws.FragmentHandlerProvider;
import com.mulesoft.service.http.impl.service.ws.PipedFragmentHandlerProvider;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.glassfish.grizzly.websockets.SimpleWebSocket;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.runtime.http.api.ws.exception.WebSocketClosedException;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;

public class OutboundWebSocket
implements WebSocket {
    private final String id;
    private final URI uri;
    private final WebSocketProtocol protocol;
    private final Set<String> groups = new HashSet<String>();
    private final GrizzlyWebSocketAdapter delegate;
    private final FragmentHandlerProvider fragmentHandlerProvider;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final OutboundWebSocketReconnectionHandler reconnectionHandler;
    private final Lock reconnectionLock = new ReentrantLock();
    private final AtomicReference<CompletableFuture<WebSocket>> ongoingReconnection = new AtomicReference<Object>(null);

    public OutboundWebSocket(String id, URI uri, WebSocketProtocol protocol, GrizzlyWebSocketAdapter delegate, OutboundWebSocketReconnectionHandler reconnectionHandler) {
        this.id = id;
        this.uri = uri;
        this.delegate = delegate;
        this.protocol = protocol;
        this.reconnectionHandler = reconnectionHandler;
        this.fragmentHandlerProvider = new PipedFragmentHandlerProvider(id);
    }

    @Override
    public CompletableFuture<Void> send(InputStream content, MediaType mediaType) {
        if (this.closed.get()) {
            return WebSocketUtils.failedFuture(new WebSocketClosedException(this));
        }
        if (!this.delegate.isOpen()) {
            return WebSocketUtils.failedFuture(new WebSocketConnectionException(this));
        }
        try {
            DataFrameEmitter emitter = MediaTypeUtils.isStringRepresentable(mediaType) ? this.textEmitter() : this.binaryEmitter();
            return WebSocketUtils.streamInDataFrames(content, emitter, t -> WebSocketUtils.mapWsException(t, this));
        }
        catch (Throwable t2) {
            return WebSocketUtils.failedFuture(WebSocketUtils.mapWsException(t2, this));
        }
    }

    @Override
    public CompletableFuture<Void> sendFrame(byte[] frameBytes) {
        if (this.closed.get()) {
            return WebSocketUtils.failedFuture(new WebSocketClosedException(this));
        }
        if (!this.delegate.isOpen()) {
            return WebSocketUtils.failedFuture(new WebSocketConnectionException(this));
        }
        try {
            return WebSocketUtils.asVoid(this.getGrizzlyWebSocket().sendRaw(frameBytes));
        }
        catch (Throwable t) {
            return WebSocketUtils.failedFuture(WebSocketUtils.mapWsException(t, this));
        }
    }

    @Override
    public byte[] toTextFrame(String data, boolean last) {
        return this.getGrizzlyWebSocket().toRawData(data, last);
    }

    @Override
    public byte[] toBinaryFrame(byte[] data, boolean last) {
        return this.getGrizzlyWebSocket().toRawData(data, last);
    }

    @Override
    public boolean supportsReconnection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<WebSocket> reconnect(RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        CompletableFuture<WebSocket> f;
        this.reconnectionLock.lock();
        try {
            f = this.ongoingReconnection.get();
            if (f != null) {
                CompletableFuture<WebSocket> completableFuture = f;
                return completableFuture;
            }
            f = new CompletableFuture();
            this.ongoingReconnection.set(f);
        }
        finally {
            this.reconnectionLock.unlock();
        }
        CompletableFuture<WebSocket> effectiveFuture = f;
        this.reconnectionHandler.reconnect(this, retryPolicyTemplate, scheduler).whenComplete((v, e) -> {
            this.reconnectionLock.lock();
            try {
                if (e != null) {
                    effectiveFuture.completeExceptionally((Throwable)e);
                } else {
                    effectiveFuture.complete((WebSocket)v);
                }
            }
            finally {
                this.ongoingReconnection.set(null);
                this.reconnectionLock.unlock();
            }
        });
        return effectiveFuture;
    }

    public FragmentHandler getFragmentHandler(Consumer<FragmentHandler> newFragmentHandlerCallback) {
        return this.fragmentHandlerProvider.getFragmentHandler(newFragmentHandlerCallback);
    }

    private DataFrameEmitter textEmitter() {
        return new DataFrameEmitter(){

            @Override
            public CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last) {
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableStream(new String(bytes, offset, len), last), t -> WebSocketUtils.mapWsException(t, OutboundWebSocket.this));
            }

            @Override
            public CompletableFuture<Void> send(byte[] bytes, int offset, int len) {
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableSend(new String(bytes, offset, len)), t -> WebSocketUtils.mapWsException(t, OutboundWebSocket.this));
            }
        };
    }

    private DataFrameEmitter binaryEmitter() {
        return new DataFrameEmitter(){

            @Override
            public CompletableFuture<Void> stream(byte[] bytes, int offset, int len, boolean last) {
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableStream(bytes, offset, len, last), t -> WebSocketUtils.mapWsException(t, OutboundWebSocket.this));
            }

            @Override
            public CompletableFuture<Void> send(byte[] bytes, int offset, int len) {
                if (offset != 0 || len != bytes.length) {
                    byte[] aux = new byte[len];
                    System.arraycopy(bytes, offset, aux, 0, len);
                    bytes = aux;
                }
                return WebSocketUtils.asVoid(OutboundWebSocket.this.delegate.completableSend(bytes), t -> WebSocketUtils.mapWsException(t, OutboundWebSocket.this));
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGroups() {
        Set<String> set = this.groups;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<String>(this.groups));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(String group) {
        Set<String> set = this.groups;
        synchronized (set) {
            this.groups.add(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(String group) {
        Set<String> set = this.groups;
        synchronized (set) {
            this.groups.remove(group);
        }
    }

    @Override
    public CompletableFuture<Void> close(WebSocketCloseCode code, String reason) {
        try {
            this.closed.set(true);
            return WebSocketUtils.asVoid(this.delegate.close(code.getProtocolCode(), reason));
        }
        catch (Throwable t) {
            return WebSocketUtils.failedFuture(t);
        }
    }

    @Override
    public WebSocket.WebSocketType getType() {
        return WebSocket.WebSocketType.OUTBOUND;
    }

    @Override
    public WebSocketProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.getGrizzlyWebSocket().isConnected();
    }

    private SimpleWebSocket getGrizzlyWebSocket() {
        return (SimpleWebSocket)this.delegate.getGrizzlyWebSocket();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OutboundWebSocket) {
            return this.id.equals(((OutboundWebSocket)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "WebSocket Id: " + this.id + "\nType: " + (Object)((Object)WebSocket.WebSocketType.OUTBOUND) + "\nURI: " + this.getUri();
    }
}

