/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.GrizzlyWebSocketHandlerManager;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.server.grizzly.HttpParser;
import org.mule.service.http.impl.service.util.DefaultRequestMatcherRegistry;

public class WebSocketHandlerRegistry {
    private final RequestMatcherRegistry<WebSocketHandlerManager> registry = new DefaultRequestMatcherRegistry<WebSocketHandlerManager>();

    public WebSocketHandlerManager addHandler(WebSocketHandler handler) {
        String path = HttpParser.normalizePathWithSpacesOrEncodedSpaces(handler.getPath());
        Preconditions.checkArgument(path.startsWith("/") || path.equals("*"), "path parameter must start with /");
        GrizzlyWebSocketHandlerManager handlerManager = new GrizzlyWebSocketHandlerManager(handler);
        handlerManager.setMatcherEntry(this.registry.add(this.pathMatcher(path), handlerManager));
        return handlerManager;
    }

    private PathAndMethodRequestMatcher pathMatcher(String path) {
        return PathAndMethodRequestMatcher.builder().path(path).methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build();
    }
}

