/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.ws;

import com.mulesoft.service.http.impl.service.ws.FragmentHandler;
import com.mulesoft.service.http.impl.service.ws.ManagedPipedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipedFragmentHandler
implements FragmentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipedFragmentHandler.class);
    private final String socketId;
    private final PipedOutputStream pipe;
    private final ManagedPipedInputStream stream;
    private final Runnable onClose;
    private boolean pipeClosed = false;

    public PipedFragmentHandler(String socketId, Runnable onClose) {
        try {
            this.stream = new ManagedPipedInputStream();
            this.pipe = new PipedOutputStream(this.stream);
            this.socketId = socketId;
            this.onClose = onClose;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Couldn't connect pipe to stream"), (Throwable)e);
        }
    }

    @Override
    public boolean write(byte[] data) throws IOException {
        if (!this.stream.isOpen()) {
            this.complete();
            return false;
        }
        if (this.pipeClosed) {
            return false;
        }
        this.pipe.write(data);
        return true;
    }

    @Override
    public void complete() {
        if (this.pipeClosed) {
            return;
        }
        try {
            this.pipe.close();
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not properly close streaming pipe for socket '%s'. %s", this.socketId, e.getMessage()), (Throwable)e);
        }
        finally {
            this.pipeClosed = true;
            this.onClose.run();
        }
    }

    @Override
    public void abort() {
        this.complete();
        try {
            this.stream.close();
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not properly close stream for socket '%s'. %s", this.socketId, e.getMessage()), (Throwable)e);
        }
        finally {
            this.onClose.run();
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.stream;
    }
}

