/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.platform.DefaultPlatformManagedDancer;
import com.mulesoft.service.oauth.internal.platform.OCSClient;
import com.mulesoft.service.oauth.internal.platform.config.DefaultPlatformManagedDancerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.runtime.oauth.api.http.HttpClientFactory;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.internal.builder.AbstractOAuthDancerBuilder;
import org.mule.runtime.oauth.internal.config.AuthDancerCredentialConfig;
import org.mule.runtime.oauth.internal.config.TokenParserConfig;

public class DefaultOAuthPlatformManagedDancerBuilder
extends AbstractOAuthDancerBuilder<PlatformManagedOAuthDancer>
implements OAuthPlatformManagedDancerBuilder {
    private final List<PlatformManagedOAuthStateListener> listeners = new ArrayList<PlatformManagedOAuthStateListener>(2);
    private final OAuthService oauthService;
    private final OCSClient.OCSClientFactory ocsClientFactory;
    private String connectionUri;
    private String organizationId;
    private String platformUrl;
    private String apiVersion;

    public DefaultOAuthPlatformManagedDancerBuilder(OAuthService oauthService, OCSClient.OCSClientFactory ocsClientFactory, SchedulerService schedulerService, LockFactory lockProvider, Map<String, ResourceOwnerOAuthContext> tokensStore, HttpClientFactory httpClientFactory, MuleExpressionLanguage expressionEvaluator) {
        super(schedulerService, lockProvider, tokensStore, httpClientFactory, expressionEvaluator);
        this.ocsClientFactory = ocsClientFactory;
        this.oauthService = oauthService;
    }

    @Override
    public OAuthPlatformManagedDancerBuilder connectionUri(String connectionUri) {
        this.connectionUri = connectionUri;
        return this;
    }

    @Override
    public OAuthPlatformManagedDancerBuilder organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @Override
    public OAuthPlatformManagedDancerBuilder platformUrl(String platformUrl) {
        this.platformUrl = platformUrl;
        return this;
    }

    @Override
    public OAuthPlatformManagedDancerBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public OAuthPlatformManagedDancerBuilder addListener(PlatformManagedOAuthStateListener listener) {
        Objects.requireNonNull(listener, "Cannot add a null listener");
        this.listeners.add(listener);
        return this;
    }

    @Override
    public PlatformManagedOAuthDancer build() {
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.clientId), "clientId cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.clientSecret), "clientSecret cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.tokenUrl), "tokenUrl cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.platformUrl), "platformUrl cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.connectionUri), "connectionUri cannot be blank");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)this.organizationId), "organizationId cannot be blank");
        DefaultPlatformManagedDancerConfig config = new DefaultPlatformManagedDancerConfig();
        config.setName(this.name);
        config.setConnectionUri(this.connectionUri);
        config.setOrganizationId(this.organizationId);
        config.setPlatformUrl(this.platformUrl);
        config.setApiVersion(this.apiVersion);
        config.setOcsClientFactory(this.ocsClientFactory);
        config.setOauthService(this.oauthService);
        config.setCredentialConfig(AuthDancerCredentialConfig.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withClientCredentialsLocation(this.clientCredentialsLocation).build());
        config.setTokenUrl(this.tokenUrl);
        config.setScopes(this.scopes);
        config.setEncoding(this.encoding);
        config.setTokenParserConfig(TokenParserConfig.builder().withResponseAccessTokenExpr(this.responseAccessTokenExpr).withResponseRefreshTokenExpr(this.responseRefreshTokenExpr).withResponseExpiresInExpr(this.responseExpiresInExpr).build());
        config.setCustomParametersExtractorsExprs(this.customParametersExtractorsExprs);
        config.setResourceOwnerIdTransformer(this.resourceOwnerIdTransformer);
        config.setSchedulerService(this.schedulerService);
        config.setLockProvider(this.lockProvider);
        config.setTokensStore(this.tokensStore);
        config.setHttpClient((HttpClient)this.httpClientFactory.get());
        config.setExpressionEvaluator(this.expressionEvaluator);
        config.setListeners(this.listeners);
        return new DefaultPlatformManagedDancer(config);
    }
}

