/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import com.mulesoft.service.oauth.internal.platform.OCSClient;
import com.mulesoft.service.oauth.internal.platform.OCSSettings;
import com.mulesoft.service.oauth.internal.platform.config.DefaultPlatformManagedDancerConfig;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.listener.PlatformManagedOAuthStateListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.oauth.internal.AbstractOAuthDancer;
import org.mule.runtime.oauth.internal.state.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlatformManagedDancer
extends AbstractOAuthDancer<DefaultPlatformManagedDancerConfig>
implements PlatformManagedOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPlatformManagedDancer.class);
    static final String REVISION_TOKEN_HEADER = "x-revisionToken";
    private final OCSClient ocsClient;
    private boolean accessTokenRefreshedOnStart = false;
    private String revisionToken;

    public DefaultPlatformManagedDancer(DefaultPlatformManagedDancerConfig config) {
        super(config);
        OCSSettings settings = new OCSSettings(config.getPlatformUrl(), config.getTokenUrl(), config.getCredentialConfig().getClientId(), config.getCredentialConfig().getClientSecret(), config.getEncoding(), config.getCredentialConfig().getClientCredentialsLocation(), config.getOrganizationId(), config.getApiVersion());
        this.ocsClient = config.getOcsClientFactory().create(config.getHttpClient(), settings, config.getExpressionEvaluator(), config.getOauthService());
        this.ocsClient.initCoreServicesDancer(config.getLockProvider(), config.getTokensStore(), config.getExpressionEvaluator());
    }

    @Override
    public void start() throws MuleException {
        super.start();
        try {
            this.accessToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (CompletionException | ExecutionException e) {
            this.stop();
            throw new LifecycleException(e.getCause(), (Object)this);
        }
        catch (InterruptedException e) {
            this.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException(e, (Object)this);
        }
    }

    @Override
    public CompletableFuture<String> accessToken() {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.doFetchAccessToken();
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored for connection URI {} token has been invalidated. Refreshing...", (Object)((DefaultPlatformManagedDancerConfig)this.config).getConnectionUri());
            return this.doFetchAccessToken();
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    private CompletableFuture<String> doFetchAccessToken() {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doAccessTokenRequest((ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    @Override
    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doRefreshTokenRequest((ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    @Override
    public CompletableFuture<PlatformManagedConnectionDescriptor> getConnectionDescriptor() {
        try {
            return this.ocsClient.getConnectionDescriptor(((DefaultPlatformManagedDancerConfig)this.config).getConnectionUri());
        }
        catch (Throwable t) {
            return ConcurrencyUtils.exceptionallyCompleted(t);
        }
    }

    private CompletableFuture<String> doAccessTokenRequest(ResourceOwnerOAuthContextWithRefreshState defaultUserState) {
        try {
            return ((CompletableFuture)this.ocsClient.getAccessToken(((DefaultPlatformManagedDancerConfig)this.config).getConnectionUri()).thenApply(response -> {
                String url = this.ocsClient.getAccessTokenUrl(((DefaultPlatformManagedDancerConfig)this.config).getConnectionUri());
                TokenResponse tokenResponse = this.parseTokenResponseAndUpdateState((HttpResponse)response, url, defaultUserState, l -> l.onAccessToken(defaultUserState));
                this.extractRevisionToken((HttpResponse)response);
                return tokenResponse.getAccessToken();
            })).exceptionally(this.tokenUrlExceptionHandler(defaultUserState));
        }
        catch (RequestAuthenticationException e) {
            return ConcurrencyUtils.exceptionallyCompleted(e);
        }
    }

    private void extractRevisionToken(HttpResponse response) {
        String receivedRevision = response.getHeaderValue(REVISION_TOKEN_HEADER);
        if (receivedRevision != null) {
            this.revisionToken = receivedRevision;
        } else {
            LOGGER.debug("Received a response without a '{}' header.", (Object)REVISION_TOKEN_HEADER);
        }
    }

    private CompletableFuture<Void> doRefreshTokenRequest(ResourceOwnerOAuthContextWithRefreshState defaultUserState) {
        try {
            return ((CompletableFuture)this.ocsClient.refreshToken(((DefaultPlatformManagedDancerConfig)this.config).getConnectionUri(), this.revisionToken).thenApply(response -> {
                String url = this.ocsClient.getRefreshTokenUrl(((DefaultPlatformManagedDancerConfig)this.config).getConnectionUri());
                this.parseTokenResponseAndUpdateState((HttpResponse)response, url, defaultUserState, l -> l.onTokenRefreshed(defaultUserState));
                this.extractRevisionToken((HttpResponse)response);
                return null;
            })).exceptionally(this.tokenUrlExceptionHandler(defaultUserState));
        }
        catch (RequestAuthenticationException e) {
            return ConcurrencyUtils.exceptionallyCompleted(e);
        }
    }

    private TokenResponse parseTokenResponseAndUpdateState(HttpResponse response, String tokenUrl, ResourceOwnerOAuthContextWithRefreshState defaultUserState, Consumer<PlatformManagedOAuthStateListener> listenerAction) {
        TokenResponse tokenResponse = this.parseTokenResponse(response, tokenUrl, false);
        ClassUtils.withContextClassLoader(DefaultPlatformManagedDancer.class.getClassLoader(), () -> {
            LOGGER.debug("Retrieved access token and expires from token url are: {}, {}", (Object)tokenResponse.getAccessToken(), (Object)tokenResponse.getExpiresIn());
            defaultUserState.setAccessToken(tokenResponse.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
            for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
            }
            this.updateOAuthContextAfterTokenResponse(defaultUserState);
            this.forEachListener(listenerAction);
        });
        return tokenResponse;
    }

    @Override
    protected TokenResponse parseTokenResponse(HttpResponse response, String tokenUrl, boolean retrieveRefreshToken) {
        if (response.getStatusCode() == HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()) {
            InputStream content = response.getEntity().getContent();
            try {
                throw new CompletionException(new TokenNotFoundException(tokenUrl, response, IOUtils.toString(content)));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(content);
                throw throwable;
            }
        }
        return super.parseTokenResponse(response, tokenUrl, retrieveRefreshToken);
    }

    @Override
    public void addListener(PlatformManagedOAuthStateListener listener) {
        this.doAddListener(listener);
    }

    @Override
    public void removeListener(PlatformManagedOAuthStateListener listener) {
        this.doRemoveListener(listener);
    }

    @Override
    public void invalidateContext() {
        this.invalidateContext("default");
    }

    @Override
    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }

    private void forEachListener(Consumer<PlatformManagedOAuthStateListener> action) {
        this.onEachListener(listener -> action.accept((PlatformManagedOAuthStateListener)listener));
    }

    String getRevisionToken() {
        return this.revisionToken;
    }
}

