/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import reactor.util.context.Context;

public final class ReactorTransactionUtils {
    public static final String TX_SCOPES_KEY = "mule.tx.activeTransactionsInReactorChain";

    private ReactorTransactionUtils() {
    }

    public static boolean isTxActiveByContext(Context ctx) {
        return ctx != null && ctx.getOrEmpty((Object)TX_SCOPES_KEY).map(txScopes -> !txScopes.isEmpty()).orElse(false) != false;
    }

    public static Function<Context, Context> popTxFromSubscriberContext() {
        return context -> {
            ArrayDeque currentTxChains = new ArrayDeque((Collection)context.getOrDefault((Object)TX_SCOPES_KEY, Collections.emptyList()));
            currentTxChains.pop();
            return context.put((Object)TX_SCOPES_KEY, currentTxChains);
        };
    }

    public static Function<Context, Context> pushTxToSubscriberContext(String location) {
        return context -> {
            ArrayDeque<String> currentTxChains = new ArrayDeque<String>((Collection)context.getOrDefault((Object)TX_SCOPES_KEY, Collections.emptyList()));
            currentTxChains.push(location);
            return context.put((Object)TX_SCOPES_KEY, currentTxChains);
        };
    }
}

