/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;

public class NamedObjectDeclarationEnricher
implements DeclarationEnricher {
    private static final MetadataType STRING_TYPE = BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().build();
    private static final Map<String, Set<String>> blocklistedExtensionsOperations = ImmutableMap.of((Object)"cxf", (Object)ImmutableSet.of((Object)"wsSecurity", (Object)"configuration"));

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        String extensionName = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName();
        final Set blocklisted = blocklistedExtensionsOperations.getOrDefault(extensionName, Collections.emptySet());
        new IdempotentDeclarationWalker(){

            @Override
            protected void onConfiguration(ConfigurationDeclaration declaration) {
                if (blocklisted.contains(declaration.getName())) {
                    return;
                }
                declaration.getDefaultParameterGroup().addParameter(NamedObjectDeclarationEnricher.this.buildNameParameter());
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private ParameterDeclaration buildNameParameter() {
        ParameterDeclaration nameParameter = new ParameterDeclaration("name");
        nameParameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        nameParameter.setParameterRole(ParameterRole.BEHAVIOUR);
        nameParameter.addModelProperty(new SyntheticModelModelProperty());
        nameParameter.setDescription("The identifier of this element used to reference it in other components");
        nameParameter.setType(STRING_TYPE, false);
        nameParameter.setRequired(true);
        nameParameter.setComponentId(true);
        return nameParameter;
    }
}

