/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.strategy;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.privileged.util.TemplateParser;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.internal.client.ComplexParameter;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessorBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public abstract class AbstractExtensionsClientProcessorsStrategy
implements ExtensionsClientProcessorsStrategy {
    protected final TemplateParser parser = TemplateParser.createMuleStyleParser();
    protected final ExtensionManager extensionManager;
    protected final Registry registry;
    protected final MuleContext muleContext;
    protected final ReflectionCache reflectionCache;
    protected final PolicyManager policyManager;
    protected final CoreEvent event;

    public AbstractExtensionsClientProcessorsStrategy(ExtensionManager extensionManager, Registry registry, MuleContext muleContext, PolicyManager policyManager, ReflectionCache reflectionCache, CoreEvent event) {
        this.extensionManager = extensionManager;
        this.registry = registry;
        this.muleContext = muleContext;
        this.policyManager = policyManager;
        this.reflectionCache = reflectionCache;
        this.event = event;
    }

    protected OperationMessageProcessor createProcessor(String extensionName, String operationName, Optional<String> configName, Map<String, ValueResolver> parameters) {
        ExtensionModel extension = this.findExtension(extensionName);
        OperationModel operation = this.findOperation(extension, operationName);
        ConfigurationProvider config = configName.map(this::findConfiguration).orElse(null);
        Map<String, ValueResolver> resolvedParams = parameters;
        try {
            OperationMessageProcessor processor = (OperationMessageProcessor)new OperationMessageProcessorBuilder(extension, operation, Collections.emptyList(), this.policyManager, this.muleContext, this.registry).setConfigurationProvider(config).setParameters(resolvedParams).setTerminationTimeout(-1L).build();
            LifecycleUtils.initialiseIfNeeded(processor, this.muleContext);
            processor.start();
            return processor;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create Operation Message Processor"), (Throwable)e);
        }
    }

    protected OperationModel findOperation(ExtensionModel extensionModel, final String operationName) {
        final Reference operation = new Reference();
        IdempotentExtensionWalker walker = new IdempotentExtensionWalker(){

            @Override
            protected void onOperation(OperationModel operationModel) {
                if (operationName.equals(operationModel.getName())) {
                    operation.set(operationModel);
                    this.stop();
                }
            }
        };
        walker.walk(extensionModel);
        if (operation.get() == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No Operation [" + operationName + "] Found"));
        }
        return (OperationModel)operation.get();
    }

    protected ConfigurationProvider findConfiguration(String configName) {
        return this.extensionManager.getConfigurationProvider(configName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No configuration [" + configName + "] found")));
    }

    protected ExtensionModel findExtension(String extensionName) {
        return this.extensionManager.getExtension(extensionName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No Extension [" + extensionName + "] Found")));
    }

    protected Map<String, ValueResolver> resolveParameters(Map<String, Object> parameters, CoreEvent event) {
        LinkedHashMap<String, ValueResolver> values = new LinkedHashMap<String, ValueResolver>();
        parameters.forEach((name, value) -> {
            ValueResolver<Object> valueResolver;
            if (value instanceof ComplexParameter) {
                ComplexParameter complex = (ComplexParameter)value;
                DefaultObjectBuilder builder = new DefaultObjectBuilder(complex.getType(), this.reflectionCache);
                this.resolveParameters(complex.getParameters(), event).forEach((propertyName, resolver) -> builder.addPropertyResolver((String)propertyName, (ValueResolver<Object>)resolver));
                try {
                    valueResolver = new StaticValueResolver(builder.build(ValueResolvingContext.builder(event).build()));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not construct parameter [%s]", name)), (Throwable)e);
                }
            } else {
                valueResolver = value instanceof String && this.parser.isContainsTemplate((String)value) ? new ExpressionValueResolver((String)value) : new StaticValueResolver<Object>(value);
            }
            try {
                LifecycleUtils.initialiseIfNeeded(valueResolver, true, this.muleContext);
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException(e);
            }
            values.put((String)name, valueResolver);
        });
        return values;
    }

    protected CoreEvent getBaseEvent() {
        return this.event == null ? MuleExtensionUtils.getInitialiserEvent() : this.event;
    }
}

