/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.execution.ExecutionResult;
import org.mule.runtime.api.component.execution.InputEvent;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.util.ObjectNameHelper;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.internal.runtime.operation.ImmutableProcessorChildContextChainExecutor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.reactivestreams.Publisher;

public final class ProcessorChainValueResolver
implements ValueResolver<Chain> {
    private final StreamingManager streamingManager;
    private final MessageProcessorChain chain;

    public ProcessorChainValueResolver(StreamingManager streamingManager, MessageProcessorChain chain) {
        this.streamingManager = streamingManager;
        this.chain = chain;
    }

    public ProcessorChainValueResolver(MuleContext ctx, StreamingManager streamingManager, List<Processor> processors) {
        this(streamingManager, new LazyInitializerChainDecorator(ctx, MessageProcessors.newChain(Optional.empty(), processors)));
        try {
            LegacyRegistryUtils.registerObject(ctx, new ObjectNameHelper(ctx).getUniqueName(""), this.chain);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not register nested MessageProcessorChain"), (Throwable)e);
        }
    }

    @Override
    public Chain resolve(ValueResolvingContext context) throws MuleException {
        return new ImmutableProcessorChildContextChainExecutor(this.streamingManager, context.getEvent(), this.chain);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    private static final class LazyInitializerChainDecorator
    implements MessageProcessorChain {
        private final MessageProcessorChain delegate;
        private final MuleContext muleContext;
        private boolean initialised = false;

        LazyInitializerChainDecorator(MuleContext ctx, MessageProcessorChain chain) {
            this.delegate = chain;
            this.muleContext = ctx;
        }

        @Override
        public void initialise() throws InitialisationException {
            if (!this.initialised) {
                LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
                this.initialised = true;
            }
        }

        @Override
        public void start() throws MuleException {
            this.initialise();
            this.delegate.start();
        }

        @Override
        public void stop() throws MuleException {
            this.delegate.stop();
        }

        @Override
        public void dispose() {
            this.delegate.dispose();
            this.initialised = false;
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return this.delegate.apply(publisher);
        }

        @Override
        public List<Processor> getMessageProcessors() {
            return this.delegate.getMessageProcessors();
        }

        @Override
        public CompletableFuture<ExecutionResult> execute(InputEvent inputEvent) {
            return this.delegate.execute(inputEvent);
        }

        @Override
        public CompletableFuture<Event> execute(Event event) {
            return this.delegate.execute(event);
        }

        @Override
        public Object getAnnotation(QName name) {
            return this.delegate.getAnnotation(name);
        }

        @Override
        public Map<QName, Object> getAnnotations() {
            return this.delegate.getAnnotations();
        }

        @Override
        public void setAnnotations(Map<QName, Object> annotations) {
            this.delegate.setAnnotations(annotations);
        }

        @Override
        public ComponentLocation getLocation() {
            return this.delegate.getLocation();
        }

        @Override
        public Location getRootContainerLocation() {
            return this.delegate.getRootContainerLocation();
        }

        @Override
        public void setMuleContext(MuleContext context) {
            this.delegate.setMuleContext(context);
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return this.delegate.process(event);
        }
    }
}

