/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.poll.PollingSourceWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.Source;

public final class SourceConfigurer {
    private final SourceModel model;
    private final ResolverSet resolverSet;
    private final ComponentLocation componentLocation;
    private final ExpressionManager expressionManager;
    private final MuleContext muleContext;
    private final boolean restarting;

    public SourceConfigurer(SourceModel model, ComponentLocation componentLocation, ResolverSet resolverSet, ExpressionManager expressionManager, MuleContext muleContext) {
        this(model, componentLocation, resolverSet, expressionManager, muleContext, false);
    }

    public SourceConfigurer(SourceModel model, ComponentLocation componentLocation, ResolverSet resolverSet, ExpressionManager expressionManager, MuleContext muleContext, boolean restarting) {
        this.model = model;
        this.resolverSet = resolverSet;
        this.componentLocation = componentLocation;
        this.expressionManager = expressionManager;
        this.muleContext = muleContext;
        this.restarting = restarting;
    }

    public Source configure(final Object source, final Optional<ConfigurationInstance> config) {
        ResolverSetBasedObjectBuilder<Object> builder = new ResolverSetBasedObjectBuilder<Object>(source.getClass(), (ParameterizedModel)this.model, this.resolverSet, this.expressionManager, this.muleContext){

            @Override
            protected Object instantiateObject() {
                return source;
            }

            @Override
            public Object build(ValueResolvingContext context) throws MuleException {
                Object source2 = this.build(this.resolverSet.resolve(context));
                IntrospectionUtils.injectDefaultEncoding(SourceConfigurer.this.model, source2, SourceConfigurer.this.muleContext.getConfiguration().getDefaultEncoding());
                IntrospectionUtils.injectRuntimeVersion(SourceConfigurer.this.model, source2, MuleExtensionModelProvider.getMuleVersion());
                IntrospectionUtils.injectComponentLocation(source2, SourceConfigurer.this.componentLocation);
                config.ifPresent(c -> IntrospectionUtils.injectRefName(source2, c.getName(), this.getReflectionCache()));
                return source2;
            }
        };
        CoreEvent initialiserEvent = null;
        ValueResolvingContext context = null;
        try {
            ValueResolver<?> valueResolver;
            initialiserEvent = NullEventFactory.getNullEvent(this.muleContext);
            context = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).withConfig(config).build();
            Object configuredSource = builder.build(context);
            PollingSourceWrapper sdkSource = SdkSourceAdapterFactory.createAdapter(configuredSource);
            if (sdkSource instanceof PollingSource && (valueResolver = this.resolverSet.getResolvers().get("schedulingStrategy")) != null) {
                context = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).build();
                SchedulingStrategy scheduler = (SchedulingStrategy)valueResolver.resolve(context);
                sdkSource = new PollingSourceWrapper((PollingSource)((Object)sdkSource), scheduler, this.resolverMaxItemsPerPoll(this.resolverSet, context, initialiserEvent), this.muleContext.getExceptionListener());
            }
            PollingSourceWrapper pollingSourceWrapper = sdkSource;
            return pollingSourceWrapper;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception was found trying to configure source of type " + source.getClass().getName()), (Throwable)e);
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
            if (context != null) {
                context.close();
            }
        }
    }

    private int resolverMaxItemsPerPoll(ResolverSet resolverSet, ValueResolvingContext context, CoreEvent event) throws MuleException {
        ValueResolver<?> valueResolver = resolverSet.getResolvers().get("maxItemsPerPoll");
        if (valueResolver == null) {
            return Integer.MAX_VALUE;
        }
        int maxItemsPerPoll = (Integer)valueResolver.resolve(context);
        if (maxItemsPerPoll < 1) {
            throw new IllegalArgumentException(String.format("The %s parameter must have a value greater than 1", "maxItemsPerPoll"));
        }
        return maxItemsPerPoll;
    }
}

