/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.pref;

import com.mulesoft.licm.pref.AbstractPropertySetPreferences;
import com.mulesoft.licm.propertyset.PropertySet;
import com.mulesoft.licm.propertyset.xml.XMLPropertySet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class MulePropertySetPreferences
extends AbstractPropertySetPreferences {
    private static final String LICENSE_KEY_STRING = "license";
    private static final String PROPERTY_SET_TYPE = "xml";
    private static PropertySet propertySet;
    private static final String PROPERTY_SET_XML_FILENAME = "muleLicenseKey.lic";

    public static void reloadProperties() {
        propertySet = MulePropertySetPreferences.loadPropertySet();
    }

    public MulePropertySetPreferences(MulePropertySetPreferences parent, String name) {
        super(parent, name);
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            FileOutputStream outputStream = new FileOutputStream(PROPERTY_SET_XML_FILENAME);
            propertySet.save(outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            System.out.println("Error persisting PropertySet");
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new MulePropertySetPreferences(this, name);
    }

    @Override
    protected String getSpi(String key) {
        PropertySet props;
        String value = super.getSpi(key);
        if (!(value != null && value.compareToIgnoreCase("null") != 0 || key.compareToIgnoreCase(LICENSE_KEY_STRING) != 0 || propertySet.get(key) != null && "null".compareToIgnoreCase(propertySet.get(key)) != 0 || (value = (props = MulePropertySetPreferences.loadPropertySet()).get(this.getFullPath(key))) == null || "null".compareToIgnoreCase(value) == 0)) {
            propertySet.put(this.getFullPath(key), value);
        }
        return value;
    }

    @Override
    protected PropertySet getPropertySet() {
        return propertySet;
    }

    @Override
    protected void putSpi(String key, String value) {
        super.putSpi(key, value);
        if (key.compareToIgnoreCase(LICENSE_KEY_STRING) == 0 && (value == null || value.compareToIgnoreCase("null") == 0)) {
            this.removeLicenseFile();
        }
    }

    @Override
    protected void removeSpi(String key) {
        super.removeSpi(key);
        if (key.compareToIgnoreCase(LICENSE_KEY_STRING) == 0) {
            this.removeLicenseFile();
        }
    }

    private void removeLicenseFile() {
        URL licenseUrl = Thread.currentThread().getContextClassLoader().getResource(PROPERTY_SET_XML_FILENAME);
        if (licenseUrl == null) {
            File propertySetFile = new File(PROPERTY_SET_XML_FILENAME);
            if (propertySetFile.exists()) {
                boolean bl = propertySetFile.delete();
            }
        } else {
            File propertySetFile = new File(licenseUrl.getFile());
            if (propertySetFile.exists()) {
                boolean bl = propertySetFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertySet loadPropertySet() {
        XMLPropertySet propertySet;
        try {
            propertySet = new XMLPropertySet();
        }
        catch (Exception e) {
            System.out.println("Failed to load PropertySet target class");
            throw new RuntimeException(e);
        }
        InputStream licenseStream = null;
        try {
            licenseStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTY_SET_XML_FILENAME);
            if (licenseStream != null) {
                try {
                    propertySet.load(licenseStream);
                }
                catch (Exception e) {
                    propertySet.clear();
                }
            }
            XMLPropertySet xMLPropertySet = propertySet;
            return xMLPropertySet;
        }
        finally {
            if (licenseStream != null) {
                try {
                    licenseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        MulePropertySetPreferences.reloadProperties();
    }
}

