/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jdbc;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import com.mulesoft.mule.runtime.bti.api.util.BitronixConfigurationUtil;
import com.mulesoft.mule.runtime.bti.internal.jdbc.BitronixJdbcXaDataSourceProvider;
import com.mulesoft.mule.runtime.bti.internal.jdbc.BitronixXaDataSourceWrapper;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.MuleConfiguration;

public class BitronixXaDataSourceBuilder {
    public static final int DEFAULT_MIN_POOL_SIZE = 4;
    public static final int DEFAULT_MAX_POOL_SIZE = 16;
    public static final int DEFAULT_MAX_IDLE = 60;
    public static final int DEFAULT_ACQUISITION_TIMEOUT_SECONDS = 30;
    public static final int DEFAULT_PREPARED_STATEMENT_CACHE_SIZE = 5;
    public static final int DEFAULT_ACQUIRE_INCREMENT = 1;
    private int minPoolSize = 4;
    private int maxPoolSize = 16;
    private int maxIdleTime = 60;
    private int acquisitionTimeoutSeconds = 30;
    private int preparedStatementCacheSize = 5;
    private int acquireIncrement = 1;
    private String name;
    private XADataSource dataSource;

    public BitronixXaDataSourceWrapper build(MuleConfiguration muleConfiguration, TransactionManager txManager) {
        Preconditions.checkState(this.name != null, "name is required");
        Preconditions.checkState(this.dataSource != null, "dataSource is required");
        Preconditions.checkState(this.minPoolSize >= 0, "minPoolSize must be greater or equal than 0");
        Preconditions.checkState(this.maxPoolSize > 0, "maxPoolSize must be greater than 0");
        Preconditions.checkState(this.maxIdleTime > 0, "maxIdleTime must be greater than 0");
        Preconditions.checkState(this.acquisitionTimeoutSeconds >= 0, "acquisitionTimeoutSeconds must equal to or grater than 0");
        Preconditions.checkState(this.preparedStatementCacheSize >= 0, "preparedStatementCacheSize must equal to or grater than 0");
        Preconditions.checkState(this.acquireIncrement > 0, "acquireIncrement must be greater than 0");
        PoolingDataSource poolingDataSource = new PoolingDataSource(new Object[]{this.dataSource});
        poolingDataSource.setClassName(BitronixJdbcXaDataSourceProvider.class.getCanonicalName());
        poolingDataSource.setMinPoolSize(this.minPoolSize);
        poolingDataSource.setMaxPoolSize(this.maxPoolSize);
        poolingDataSource.setMaxIdleTime(this.maxIdleTime);
        poolingDataSource.setAcquireIncrement(this.acquireIncrement);
        poolingDataSource.setAllowLocalTransactions(true);
        poolingDataSource.setAutomaticEnlistingEnabled(false);
        poolingDataSource.setUniqueName(BitronixConfigurationUtil.createUniqueIdForResource(muleConfiguration, this.name));
        poolingDataSource.setAcquisitionTimeout(this.acquisitionTimeoutSeconds);
        poolingDataSource.setPreparedStatementCacheSize(this.preparedStatementCacheSize);
        poolingDataSource.setEnableJdbc4ConnectionTest(true);
        return new BitronixXaDataSourceWrapper(poolingDataSource, this.dataSource, txManager);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public XADataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(XADataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getAcquisitionTimeoutSeconds() {
        return this.acquisitionTimeoutSeconds;
    }

    public void setAcquisitionTimeoutSeconds(int acquisitionTimeoutSeconds) {
        this.acquisitionTimeoutSeconds = acquisitionTimeoutSeconds;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public void setAcquireIncrement(int acquireIncrement) {
        this.acquireIncrement = acquireIncrement;
    }
}

